package net.smokerz.linux.misc.batterymonitor.gui;

import java.awt.Color;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JLabel;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import net.smokerz.linux.misc.batterymonitor.ACPISymbols;
import net.smokerz.linux.misc.batterymonitor.ACPIUtil;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcModel;

/**
 * GuiMain
 * @author smoker
 * @version 0.0.1(2002/06/13)
 */
public class GuiMain extends JFrame implements ActionListener, Runnable, MouseListener{
	private boolean hasACPIBattery = false;
	private boolean showCationFlag = false;
	private String PATH = null;
	private JPanel mainPanel = new JPanel();
	private JLabel label = new JLabel();
	private String title = "discharging";
	private int btValue = 0;
	private int interval = 5;
	private TitledBorder tBorder = new TitledBorder(new EtchedBorder(EtchedBorder.LOWERED),
							title, TitledBorder.CENTER, TitledBorder.TOP);
	private JPopupMenu popup = null;

	private boolean DEBUG = false;
	
	public GuiMain(String path) {
		super("monitor");
		if (System.getProperty("DEBUG") != null &&
				System.getProperty("DEBUG").equals("true")) { 
			this.DEBUG = true;
		}

		this.PATH = path;
		this.setBounds(100, 100, 100, 75);

		this.addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) { destroy(); }
		});
		this.mainPanel.setBorder(this.tBorder);

		Thread thread = new Thread(this);
		thread.start();

		mainPanel.add(label);

		this.getContentPane().add(this.mainPanel);

		setPopupMenu();


		this.setVisible(true);
	}

	public void setPopupMenu() {
		PopupMenu popupMenu = new PopupMenu(this);
		this.mainPanel.addMouseListener(this);
		popup = popupMenu.init();
	}

	public void setCationWindow(String str) {

	}

	public void setCationOK(boolean flag) {
		this.showCationFlag = flag;

	}
	
	public void run() {
		try {
			ACPIUtil util = new ACPIUtil(this.PATH);
			while(true) {
				util.init();

				//set parsentage
				double result = util.getParsentage();
				this.btValue = (int)(result * 100);
				this.label.setText(" [ " + this.btValue + " % ]");

				if (DEBUG) {
					System.out.println("getParsentage [" + util.getParsentage() + "]");
					System.out.println("this.btValue [" + this.btValue + "]");
				}

				//set charging
				boolean chgFlg = util.hasCharging();
				if (chgFlg) {
					this.tBorder.setTitle(ACPISymbols.CHARGING);
					this.tBorder.setTitleColor(Color.red);
				} else {
					this.tBorder.setTitle(ACPISymbols.DISCHARGING);
					this.tBorder.setTitleColor(Color.black);
				}
				if (DEBUG) {
					System.out.println("hasCharging [" + chgFlg + "]");
				}
				
				this.repaint();
				Thread.sleep(this.interval*1000);
			}
		} catch(InterruptedException ie) {
			ie.printStackTrace();
		}
	}

	public void destroy() {
		System.exit(0);
	}

	public void mouseClicked(MouseEvent e) {}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}

	public void mousePressed(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.popup.show(e.getComponent(), e.getX(), e.getY());
		}
	}

	public void mouseReleased(MouseEvent e) {
		if (e.isPopupTrigger()) {
			this.popup.show(e.getComponent(), e.getX(), e.getY());
		}
	}

	
	public void actionPerformed(ActionEvent event) {
		String action = event.getActionCommand();
		if (action.equals(ACPISymbols.MENU_EXIT)) {
			destroy();
		}

	}
}


