package net.smokerz.linux.misc.batterymonitor.gui;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * cation window
 * @author smoker
 * @version 0.0.1(2002/06/05)
 */
public class CationWindow extends JFrame implements ActionListener {
	private final String OK = "OK";
	private GuiMain guiMain = null;
	private Dimension screensize = Toolkit.getDefaultToolkit().getScreenSize();
	private Dimension defSize = new Dimension(200, 100);

	public CationWindow(GuiMain guiMain, String title, String msg) {
		super(title);
		this.guiMain = guiMain;
		this.setBounds((screensize.width-defSize.width)/2,
						(screensize.height-defSize.height)/2, defSize.width, defSize.height);

		JPanel panel = new JPanel();
		JLabel label = new JLabel(msg);
		panel.add(label);

		this.getContentPane().add(panel);
		this.setVisible(true);
	}

	public void actionPerformed(ActionEvent e)  {
		String event = e.getActionCommand();
		if (event.equals(this.OK)) {
			this.guiMain.setCationOK(false);
			this.setVisible(false);
		}
	}
}
