package net.smokerz.linux.misc.batterymonitor;

import java.util.ArrayList;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcStateModel;
/**
 * get Proc information 
 *
 * @author smoker
 * @version 0.0.1(2002/06/02)
 */

public class GetACPIProcState {
	private boolean DEBUG = false;
	private String path = null;
	private ACPIProcStateModel state = null;
	
	public GetACPIProcState(String path) {
		this.path = path;
		String envDebug = System.getProperty("DEBUG");
		if (envDebug != null && envDebug.equals("true")) {
			this.DEBUG = true;
		}
		
	}

	public void init() throws ACPIBatteryNotFoundException, FileNotFoundException, IOException{
		if (DEBUG) {
			System.out.println("start init state");
			System.out.println("TARGET [" + this.path + ACPISymbols.STATE+ "]");
		}
		BufferedReader in = new BufferedReader(new FileReader(this.path + ACPISymbols.STATE));
		ArrayList list = new ArrayList();
		for (int i = 0; i <= 5; i++) {
			String str = in.readLine();
			//if (DEBUG) System.out.println(str);
			if (str == null || str.length() <= 0) {
				throw new ACPIBatteryNotFoundException();
			}

			StringTokenizer token = new StringTokenizer(str, ":");
			String key = token.nextToken();
			String value = token.nextToken();
			if (i == 0 && value != null && value.equals(ACPISymbols.YES)) {
				throw new ACPIBatteryNotFoundException("no present...");
			}
			if(DEBUG) System.out.println(key + " : " + value);
			list.add(value.trim());
		}

		if (in != null) {
			in.close();
			in = null;
		}
		
		this.state = new ACPIProcStateModel( (String)list.get(0),
							(String)list.get(1),
							(String)list.get(2),
							getIntValue((String)list.get(3)),
							getIntValue((String)list.get(4)),
							getIntValue((String)list.get(5))
						);

		if (DEBUG) {
			System.out.println("PRESENT [" + this.state.getPresent() + "]");
			System.out.println("CAPACITY STATE [" + this.state.getCapacityState() + "]");
			System.out.println("CHARGE STATE [" + this.state.getChargingState() + "]");
			System.out.println("PRESENT RATE [" + this.state.getPresentRate() + "]");
			System.out.println("REMAINING CAPACITY [" + this.state.getRemainingCapacity() + "]");
			System.out.println("PRESENT VOLTAGE [" + this.state.getPresentVoltage() + "]");
			System.out.println("end init state...");
		}
	}

	public ACPIProcStateModel getStateModel() {
		return this.state;
	}

	private int getIntValue(String str) {
		StringTokenizer token = new StringTokenizer(str);
		return Integer.parseInt(token.nextToken().trim());
	}
}

