package net.smokerz.linux.misc.batterymonitor;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcModel;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcStateModel;
import net.smokerz.linux.misc.batterymonitor.model.ACPIProcInfoModel;

/**
 *
 * @author smoker
 * @version 0.0.1(2002/06/04)
 * @see ACPIProcModel
 * @see ACPIProcStateModel
 * @see ACPIProcInfoModel
 */
public class GetACPIProc {
	/**
	 * ACPIProcModel
	 */
	private ACPIProcModel model = null;

	/**
	 * ACPI Battery Base PATH
	 */
	private String PATH = null;

	/**
	 * 
	 * @param path ACPI Battery Base Path
	 */
	public GetACPIProc(String path) {
		this.PATH = path;
	}

	/**
	 * init
	 * @throws ACPIBatteryNotFoundException ACPIBatteryNotFoundException
	 * @throws FileNotFoundException FileNotFoundException
	 * @throws IOException IOException
	 */
	public void init() throws ACPIBatteryNotFoundException, FileNotFoundException, IOException {
		GetACPIProcState stateModel = new GetACPIProcState(this.PATH);
		stateModel.init();
		GetACPIProcInfo infoModel = new GetACPIProcInfo(this.PATH);
		infoModel.init();
		this.model = new ACPIProcModel(stateModel.getStateModel(), infoModel.getInfoModel());
	}

	/**
	 * get ACPIProcModel
	 * @return ACPIProcModel model
	 */
	public ACPIProcModel getACPIModel() {
		return this.model;
	}
}

