////////////////////////////////////////////////////////////////////////////
// CTxtColorMgr_cpp 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TxtColorMgr_html.h"

using namespace NLangExt;
using namespace NLangExt_html;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTxtColorMgr_html::CTxtColorMgr_html()
{
	int i;
	const int ITsize = sizeof( IndexTable ) / sizeof( IndexTable[0] );
	for ( i = 0; i < ITsize; i++ ) IndexTable[i] = 0;

	IndexTable[ CCT_OUTER_STRING ] = 0;
	IndexTable[ CCT_LESSTHAN ] = 1;
	IndexTable[ CCT_GREATERTHAN ] = 1;
	IndexTable[ CCT_INNER_STRING ] = 1;
	IndexTable[ CCT_KEYWORD ] = 2;
	IndexTable[ CCT_STRING1_LEFT ] = 3;
	IndexTable[ CCT_STRING1_RIGHT ] = 3;
	IndexTable[ CCT_STRING1_MID ] = 3;
	IndexTable[ CCT_STRING2_LEFT ] = 3;
	IndexTable[ CCT_STRING2_RIGHT ] = 3;
	IndexTable[ CCT_STRING2_MID ] = 3;
	IndexTable[ CCT_COMMENT_LEFT ] = 4;
	IndexTable[ CCT_COMMENT_RIGHT ] = 4;
	IndexTable[ CCT_COMMENT_MID ] = 4;
	IndexTable[ CCT_NULL ] = 0;
}

CTxtColorMgr_html::~CTxtColorMgr_html()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
CErrorBool CTxtColorMgr_html::Initialize( VClsPtr< CConfigInfo > pConf )
{
	vColor[0] = pConf->RefHTML_NormalTextF_Color();
	vColor[1] = pConf->RefHTML_TagF_Color();
	vColor[2] = pConf->RefHTML_KeywordF_Color();
	vColor[3] = pConf->RefHTML_SringF_Color();
	vColor[4] = pConf->RefHTML_CommentF_Color();
	if ( !m_HM.Initialize( pConf->RefHTML_KeywordList().c_str() ) )
		return CErrorBool( pConf->RefFailedToReadKeywordListMsg() );
	return true;
}

// Ѥ뿧ο
int CTxtColorMgr_html::GetColorCount() const
{
	return 5;
}

// 
Pixel CTxtColorMgr_html::GetColor( int idx ) const
{
	const int VCsize = sizeof( vColor ) / sizeof( vColor[0] );
	assert( idx >= 0 && idx < VCsize );
	return vColor[idx];
}

// 󤫤鿧ΥǥåѴ
int CTxtColorMgr_html::TranseToIdx( unsigned char c ) const
{
	const int ITsize = sizeof( IndexTable ) / sizeof( IndexTable[0] );
	assert( c >= 0 && c < ITsize );
	return IndexTable[c];
}

// ֤ǹ
void CTxtColorMgr_html::InitiUpdate( T_LineData &rData ) const
{
	InitUpdateColorFunc( m_HM, rData );
}

// ʸιȼι
void CTxtColorMgr_html::Update( T_LineData &rData, const T_SelRange &range ) const
{
	UpdateColorFunc( m_HM, rData, range );
}
