////////////////////////////////////////////////////////////////////////////
// CTxtColorMgr_cpp 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TxtColorMgr_cpp.h"

using namespace NLangExt;
using namespace NLangExt_cpp;

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTxtColorMgr_cpp::CTxtColorMgr_cpp()
{
	int i;
	for ( i = 0; i < 78; i++ ) IndexTable[i] = 0;
	IndexTable[ CCT_ALPHANUMERIC ] = 0;
	IndexTable[ CCT_KEYWORD ] = 1;
	IndexTable[ CCT_COM1_LEFT ] = 2;
	IndexTable[ CCT_COM1_RIGHT ] = 2;
	IndexTable[ CCT_COM1_TEXT ] = 2;
	IndexTable[ CCT_COM2_LEFT ] = 2;
	IndexTable[ CCT_COM2_RIGHT ] = 2;
	IndexTable[ CCT_COM2_TEXT ] = 2;
	IndexTable[ CCT_DQUOTE_LEFT ] = 3;
	IndexTable[ CCT_DQUOTE_RIGHT ] = 3;
	IndexTable[ CCT_DQUOTE_TEXT ] = 3;
	IndexTable[ CCT_SQUOTE_LEFT ] = 3;
	IndexTable[ CCT_SQUOTE_RIGHT ] = 3;
	IndexTable[ CCT_SQUOTE_TEXT ] = 3;
	IndexTable[ CCT_OTHER ] = 0;
	IndexTable[ CCT_NULL ] = 0;
}

CTxtColorMgr_cpp::~CTxtColorMgr_cpp()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
CErrorBool CTxtColorMgr_cpp::Initialize( VClsPtr< CConfigInfo > pConf )
{
	vColor[0] = pConf->RefCPP_NormalTextF_Color();
	vColor[1] = pConf->RefCPP_KeywordF_Color();
	vColor[2] = pConf->RefCPP_CommentF_Color();
	vColor[3] = pConf->RefCPP_SringF_Color();
	if ( !m_HM.Initialize( pConf->RefCPP_KeywordList().c_str() ) )
		return CErrorBool( pConf->RefFailedToReadKeywordListMsg() );
	return true;
}

// Ѥ뿧ο
int CTxtColorMgr_cpp::GetColorCount() const
{
	return 4;
}

// 
Pixel CTxtColorMgr_cpp::GetColor( int idx ) const
{
	assert( idx >= 0 && idx < 4 );
	return vColor[idx];
}

// 󤫤鿧ΥǥåѴ
int CTxtColorMgr_cpp::TranseToIdx( unsigned char c ) const
{
	assert( c >= 0 && c < 78 );
	return IndexTable[c];
}

// ֤ǹ
void CTxtColorMgr_cpp::InitiUpdate( T_LineData &rData ) const
{
	InitUpdateColorFunc( m_HM, rData );
}

// ʸιȼι
void CTxtColorMgr_cpp::Update( T_LineData &rData, const T_SelRange &range ) const
{
	UpdateColorFunc( m_HM, rData, range );
}
