////////////////////////////////////////////////////////////////////////////
// CTaEditFindDlg 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "TaEditFindDlg.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CTaEditFindDlg::CTaEditFindDlg() :
	pDraw( NULL ),
	IsShown( false )
{

}

CTaEditFindDlg::~CTaEditFindDlg()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CTaEditFindDlg::OnCreate( Widget argWgt, XtPointer user_data )
{
	IsShown = false;
}

void CTaEditFindDlg::OnClose( Widget argWgt, XtPointer user_data )
{
	IsShown = false;
}

// ӥ塼֥Ȥ
void CTaEditFindDlg::SetDrawObj( CTaEditDraw *argpDraw )
{
	pDraw = argpDraw;
}

// Ĥץܥβ
void CTaEditFindDlg::OnFindExit( Widget argWgt, XtPointer user_data )
{
	IsShown = false;
	XtUnmanageChild( m_FindDlg );
}

// ִץܥβ
void CTaEditFindDlg::OnFindAllReplace( Widget argWgt, XtPointer user_data )
{
	Arg al[2];
	int ac = 0;
	Boolean EnableReplaceNullStr;
	Boolean IgnoreCase;
	wstring PatternStr;
	wstring ReplaceStr;
	VClsPtr< CConfigInfo > pConfig = m_TaEditShell->GetConfigInfo();

	// ֶʸȤִץȥܥͤ
	XtSetArg( al[ac], XmNset, &EnableReplaceNullStr ); ac++;
	XtGetValues( m_FindReplaceNullStr, al, ac );

	// ѥڤִꤹʸ
	GetPatternStr( &PatternStr );
	GetReplaceStr( &ReplaceStr );

	// ʸȤִĤƤ餺ġ
	// ִꤹʸ󤬶ξϡִԤʤ
	if ( ReplaceStr.length() <= 0 && !EnableReplaceNullStr ) {
		m_TaEditShell->ShowErrorMsgBox( pConfig->RefReplaceStrIsNullMsg() );
		return ;
	}

	// ѥϤƤʤСԤʤ
	if ( PatternStr.length() <= 0 ) return ;

	// ʸ/ʸƱ뤹ץȥܥͤ
	XtSetArg( al[ac], XmNset, &IgnoreCase ); ac++;
	XtGetValues( m_FindIgnoreCase, al, ac );

	// ִ
	GetTextEditorObj()->ReplaceAll( PatternStr, ReplaceStr, IgnoreCase ? true : false );	
}

// ִץܥβ
void CTaEditFindDlg::OnFindReplace( Widget argWgt, XtPointer user_data )
{
	Arg al[2];
	int ac = 0;
	Boolean EnableReplaceNullStr;
	wstring ReplaceStr;
	VClsPtr< CConfigInfo > pConfig = m_TaEditShell->GetConfigInfo();
	CTextEdit *pTextEdit;
	T_SelRange CurSelRange;

	// ֶʸȤִץȥܥͤ
	XtSetArg( al[ac], XmNset, &EnableReplaceNullStr ); ac++;
	XtGetValues( m_FindReplaceNullStr, al, ac );

	// ִꤹʸ
	GetReplaceStr( &ReplaceStr );

	// ʸȤִĤƤ餺ġ
	// ִꤹʸ󤬶ξϡִԤʤ
	if ( ReplaceStr.length() <= 0 && !EnableReplaceNullStr ) {
		m_TaEditShell->ShowErrorMsgBox( pConfig->RefReplaceStrIsNullMsg() );
		return ;
	}

	pTextEdit = GetTextEditorObj();
	CurSelRange = pDraw->GetCursorInfo()->GetSelRange();	// ߤϰϤ

	// ߤϰϤθ̤ƱϰϤǤꡢ
	// ϰϤĹ0礭СִԤ
	if ( T_SelRange( T_CurPos( 0, 0 ), T_CurPos( 0, 0 ) ) < CurSelRange && 
			CurSelRange == LastSearchSel ) {
		pTextEdit->PasteText( ReplaceStr, true );	// ִ
	}

	// ʸθ
	OnFindNext( argWgt, user_data );
}

// ָץܥβ
void CTaEditFindDlg::OnFindNext( Widget argWgt, XtPointer user_data )
{
	Arg al[2];
	int ac = 0;
	Boolean IgnoreCase;
	wstring PatternStr;

	// ѥʸ
	GetPatternStr( &PatternStr );

	// ʸ/ʸƱ뤹ץȥܥͤ
	XtSetArg( al[ac], XmNset, &IgnoreCase ); ac++;
	XtGetValues( m_FindIgnoreCase, al, ac );

	// ѥϤƤʤСԤʤ
	if ( PatternStr.length() <= 0 ) return ;

	// 
	GetTextEditorObj()->FindText( PatternStr, IgnoreCase ? true : false );

	// ϰϤ
	LastSearchSel = pDraw->GetCursorInfo()->GetSelRange();
}

// ɽ
void CTaEditFindDlg::ShowDlg()
{
	if ( !IsShown ) {
		// ޤɽƤʤäϡޥ͡ɽ
		XtManageChild( m_FindDlg );
		IsShown = true;
	}
	else {
		// ǤɽƤˤϡɥ̤˻äƤ
		Display *pDisplay = XtDisplay( m_FindDlg );
		Window window = XtWindow( m_FindDlg );
		XSetInputFocus( pDisplay, window, RevertToParent, CurrentTime );
	}
}

// ˡ
enumFINDTYPE CTaEditFindDlg::GetFindType() const
{
	// ñץȥܥ
	if ( XmToggleButtonGetState( m_FindTypeNormal ) )
		return FINDTYPE_NORMAL;

	// ֥磻ɥɡץȥܥ
	if ( XmToggleButtonGetState( m_FindTypeWildcard ) )
		return FINDTYPE_WILDCARD;

	// ɽץȥܥ
	if ( XmToggleButtonGetState( m_FindTypeRegex ) )
		return FINDTYPE_REGEX;

	// Ȥꤢ
	return FINDTYPE_NORMAL;
}

// оݤʸ
void CTaEditFindDlg::GetPatternStr( wstring *pStr ) const
{
	assert( NULL != this && NULL != pStr && NULL != m_FindPatternStr );

	// Ϥ줿ʸ
	wchar_t *pIptStr = XmTextFieldGetStringWcs( m_FindPatternStr );

	// ȥܥˤ碌ʸù
	switch ( GetFindType() ) {
	case FINDTYPE_NORMAL:
		// Ϥ줿ʸʸ򸡺ɽѴ
		ConvertNormalPtnToRegexPtn( pIptStr, pStr );
		break;

	case FINDTYPE_WILDCARD:
		// 磻ɥɤѤ줿ʸ򸡺ɽѴ
		ConvertWildcardPtnToRegexPtn( pIptStr, pStr );
		break;

	case FINDTYPE_REGEX:
		// ʸ򤽤Τޤɽȸʤ
		(*pStr) = pIptStr;
	}

	XtFree( reinterpret_cast< char* >( pIptStr ) );
}

// ִʸ
void CTaEditFindDlg::GetReplaceStr( wstring *pStr ) const
{
	assert( NULL != this && NULL != pStr && NULL != m_FindReplaceStr );
	wchar_t *str = XmTextFieldGetStringWcs( m_FindReplaceStr );
	(*pStr) = str;
	XtFree( reinterpret_cast< char* >( str ) );
}

// ƥԽ֥Ȥ
VClsPtr< CTextEdit > CTaEditFindDlg::GetTextEditorObj() const
{
	assert( NULL != this && NULL != m_TaEditShell );
	return m_TaEditShell->GetTextEditor();
}

// Ϥ줿оʸɽѴ
void CTaEditFindDlg::ConvertNormalPtnToRegexPtn( const wchar_t *pIptPtn, wstring *pRegexPtn ) const
{
	assert( NULL != pIptPtn && NULL != pRegexPtn );

	// Ϥ줿ʸˡREGEX_SPECIALCODE˴ޤޤü쵭椬ѤƤ顢
	// ץ󥹤
	while ( (*pIptPtn) ) {
		if ( L'\\' == (*pIptPtn) || wcschr( REGEX_SPECIALCODE, (*pIptPtn) ) )
			(*pRegexPtn) += L'\\';
		(*pRegexPtn) += (*pIptPtn);
		pIptPtn++;
	}
}

// Ϥ줿磻ɥɤˤ븡ѥ򡢤ƱɽѴ롣
void CTaEditFindDlg::ConvertWildcardPtnToRegexPtn( const wchar_t *pIptPtn, wstring *pRegexPtn ) const
{
	assert( NULL != pIptPtn && NULL != pRegexPtn );

	// Ϥ줿ʸ*ޤޤƤ{.}ˡ
	// ?ޤޤƤ.ִ롣
	// \\\\ˡ\**ˡ\??֤롣

	while ( (*pIptPtn) ) {
		switch ( (*pIptPtn) ) {
		case L'*':
			(*pRegexPtn) += L"{.}";
			break;
		case L'?':
			(*pRegexPtn) += L".";
			break;
		case '\\':
			pIptPtn++;
			if ( NULL == (*pIptPtn) ) {
				// \ǽäƤ롣Ȥꤢ\\Ϥ
				(*pRegexPtn) += L"\\\\";
				return ;
			}
			if ( L'\\' == (*pIptPtn)  )
				(*pRegexPtn) += L"\\\\";
			else
				(*pRegexPtn) += (*pIptPtn);
			break;
		default:
			if ( wcschr( REGEX_SPECIALCODE, (*pIptPtn) ) )
				(*pRegexPtn) += L'\\';
			(*pRegexPtn) += (*pIptPtn);
		}
		pIptPtn++;
	}
	
}


