// LineData.h: LineData 饹Υ󥿡ե
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_LINEDATA_H__750BC0E2_7E3B_426D_B2DE_7C4E99519203__INCLUDED_)
#define AFX_LINEDATA_H__750BC0E2_7E3B_426D_B2DE_7C4E99519203__INCLUDED_

#include "TaEdit_std.h"
#include "DrawCharPos.h"

// ʸݻ빽¤
typedef struct tagTA_CHAR
{
	tagTA_CHAR() : moji( L'\0' ), iro( 0 ) {};
	tagTA_CHAR( wchar_t argMoji, unsigned char argIro ) {
		moji = argMoji;
		iro = argIro;
	};

	wchar_t moji;
	unsigned char iro;
} TA_CHAR;

class CTaEditDraw;

class CLineData  
{
public:
	CLineData();
	CLineData( const CLineData &r );
	CLineData( const wchar_t *pStr );

	virtual ~CLineData();

	void push_back( TA_CHAR c );

	TA_CHAR operator []( size_t idx ) const;

	unsigned char getIro( int idx ) const;
	void setIro( int idx, unsigned char c );

	const CLineData& operator =( const CLineData &r );

	void set( size_t idx, TA_CHAR c );

	size_t length() const;

	const wstring& getString() const;

	void clear();

	bool InsertBlank( size_t pos, size_t length );

	void Delete( size_t s, size_t e );

	const CTimeSpec& GetModifiedTime() const;

	// ־Ѳǽݤ
	bool IsEnableDrawCharPos() const;

	const CDrawCharPos& GetDrawCharPos() const;

	// ֤򹹿
	bool UpdateDrawCharPos( const CTaEditDraw *pDraw ) const;

	// ĥμ
	bool GetExtendInfo( int idx ) const;

	// ĥ
	void SetExtendInfo( int idx, bool f );

	// ֤򹹿
	void UpdateTime();

protected:
	// 줿
	void OnUpdate();

	// vIroˤϲԥɤʸοݻ뤿
	// vMoji+1ĹȤʤ롣
	wstring vMoji;	// ʸ
	vector< unsigned char > vIro;		// 

	vector< bool > ExtendInfo;	// ԤȤγĥ

	CTimeSpec ModifiedTime;	// Ǹѹ줿Ȥλ

	mutable CDrawCharPos DrawCharPos;	// ʸ褵줿
};

// Ԥݻǡ
typedef vector< CLineData > T_LineData;

// T_LineDataΥƥ졼
typedef T_LineData::iterator T_LineDataItr;

// T_LineDataconstʥƥ졼
typedef T_LineData::const_iterator T_LineDataItr_c;

#endif // !defined(AFX_LINEDATA_H__750BC0E2_7E3B_426D_B2DE_7C4E99519203__INCLUDED_)
