////////////////////////////////////////////////////////////////////////////
// CConverter 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "Converter.h"
#include <memory.h>
#include <errno.h>
#include <string.h>

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CConverter::CConverter() :
	m_cd( (iconv_t)-1 )
{

}

CConverter::~CConverter()
{
	// Ѵǥץ˴
	if ( (iconv_t)-1 != m_cd )
		iconv_close( m_cd );
	m_cd = (iconv_t)-1;
}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
bool CConverter::Initialize( const char *InCode, const char *OutCode, NEWLINE_CHAR NLC )
{
	NewLineChar = NLC;
	// ꤵ줿ѴԤѴǥץ
	m_cd = iconv_open( OutCode, InCode );
	if ( (iconv_t)-1 == m_cd )
		return false;
	return true;
}

// ʥ󥳡ѴԤʤ
bool CConverter::Initialize( NEWLINE_CHAR NLC )
{
	m_cd = (iconv_t)-1;
	NewLineChar = NLC;
	return true;
}

// Ѵ
bool CConverter::Convert( FILE *infile, FILE *outfile ) const
{
	if ( (iconv_t)-1 == m_cd )
		return ConvertWithoutTransEncode( infile, outfile );
	else
		return ConvertWithTransEncode( infile, outfile );
}

// 󥳡ѴԤ
bool CConverter::ConvertWithTransEncode( FILE *infile, FILE *outfile ) const
{
	char InBuf[1024];
	char OutBuf[4096];
	const char *pInBuf;
	char *pOutBuf;
	size_t InLen;
	size_t OutLen;
	size_t w;
	bool wflg;

	InLen = 0;
	OutLen = 1024;
	while ( !feof( infile ) && !ferror( infile ) && !ferror( outfile ) ) {
		// ϥХåե
		InLen += fread( InBuf + InLen, sizeof( char ), 1024 - InLen, infile );
		// Ѵ
		pInBuf = InBuf;
		pOutBuf = OutBuf + ( 1024 - OutLen );
		if ( iconv( m_cd, &pInBuf, &InLen, &pOutBuf, &OutLen ) ) {
			switch ( errno ) {
			case EILSEQ:
				// ʥХȤɤФ
				InLen--;
				pInBuf++;
			case E2BIG:
			case EINVAL:
				// ϥХåե˻Ĥäǡ˲ͤ
				memmove( InBuf, pInBuf, InLen );
				break;
			case EBADF:
				// 顼
				return false;
			}
		}
		// ѴǡϤ
		w = ( pOutBuf - OutBuf );	// ϥХåեäƤʸ
		wflg = ( feof( infile ) || ferror( infile ) );
		OutLen += WriteString( OutBuf, w, outfile, wflg );
		if ( feof( outfile ) || ferror( outfile ) )
			return false;
	}
	return true;
}

// 󥳡ѴԤʤʲԥɤѴΤߡ
bool CConverter::ConvertWithoutTransEncode( FILE *infile, FILE *outfile ) const
{
	char pBuf[4096];
	unsigned int BufLen = 0;

	while ( !feof( infile ) && !ferror( infile ) && !ferror( outfile ) ) {
		// Хåե
		BufLen += fread( pBuf + BufLen, sizeof( char ), sizeof( pBuf ) - BufLen, infile );
		// Ϥ
		BufLen -= WriteString( pBuf, BufLen, outfile, false );
	}
	if ( BufLen > 0 )
		WriteString( pBuf, BufLen, outfile, true );
	return ( !ferror( infile ) && !ferror( outfile ) );
}


// ԥɤѴԤĤʸϤ
size_t CConverter::WriteString( char *pBuf, size_t len, FILE *pFile, bool IsFinish ) const
{
	int i;
	int hc = 0;	// ԥɤνѡʸݻ
	bool flg;	// ԥɤνѡhcʸݻƤϿ

	if ( len <= 0 ) return 0;

	// ԥɤѴԤɬפʤ
	if ( NC_NON == NewLineChar )
		return fwrite( pBuf, sizeof( char ), len, pFile );

	flg = false;
	for ( i = 0; i < len && !feof( pFile ) && !ferror( pFile ); i++ ) {
		if ( flg ) {
			if ( pBuf[i] != 0x0A && pBuf[i] != 0x0D ) {
				// hcʬβԥɤȡΰʸ
				OutputNewLine( pFile );
				fputc( pBuf[i], pFile );
				flg = false;
				continue;
			}
			if ( pBuf[i] == 0x0A && hc == 0x0D || pBuf[i] == 0x0D && hc == 0x0A ) {
				// CRLFȤ߹碌ϡԥɰʬȸʤ
				OutputNewLine( pFile );
				flg = false;
				continue;
			}
			// CRϢ³⤷LFϢ³
			// ȤꤢhcʬβԥɤϤ
			OutputNewLine( pFile );
		}
		else {
			if ( pBuf[i] == 0x0A || pBuf[i] == 0x0D ) {
				// ԥɤиϡhcݻ
				hc = pBuf[i];
				flg = true;	// ե饰ꤹ
			}
			else {
				// ʬΰʸϤ
				fputc( pBuf[i], pFile );
			}
		}
	}

	// hc˻ĤäƤԥɤϤ
	if ( flg ) {
		if ( ( hc == 0x0D || hc == 0x0A ) && !IsFinish ) {
			// ĤäƤΤCR⤷LFǡ
			// ³ˤϡhc˻ĤäƤԥɤϽʤ
			pBuf[0] = hc;
			return i - 1;
		}
		else {
			OutputNewLine( pFile );
			return i;
		}
	}
	return i;
}

// ԥɤϤ
void CConverter::OutputNewLine( FILE *pFile ) const
{
	switch ( NewLineChar ) {
	case NC_CR:
		fputc( 0x0D, pFile );
		break;
	case NC_LF:
		fputc( 0x0A, pFile );
		break;
	case NC_CRLF:
		fputc( 0x0D, pFile );
		fputc( 0x0A, pFile );
		break;
	case NC_LFCR:
		fputc( 0x0A, pFile );
		fputc( 0x0D, pFile );
		break;
	}
}


