/////////////////////////////////////////////////////////////////////////////
// HighlightMgr_cpp.h CHighlightMgr_cpp饹Υץơ
// 
/////////////////////////////////////////////////////////////////////////////

#if !defined( HIGHLIGHTMGR_CPP_H_INCLUDED_ )
#define HIGHLIGHTMGR_CPP_H_INCLUDED_

#include <vector>
#include <algorithm>
#include "../KeywordFinder.h"

using namespace std;

namespace NLangExt {

namespace NLangExt_cpp {

///////////////////////////////////////////////////////////////////////////
// CProgPtr C++ץΥɤΥݥȡӹʸǤȽ

// ߥݥȤƤʸμ򼨤
enum CURCHARTYPE {
	CCT_ALPHANUMERIC	= 0x01,
	CCT_KEYWORD			= 0x11,
	CCT_COM1_LEFT		= 0x02,
	CCT_COM1_RIGHT		= 0x03,
	CCT_COM1_TEXT		= 0x04,
	CCT_COM2_LEFT		= 0x05,
	CCT_COM2_RIGHT		= 0x06,
	CCT_COM2_TEXT		= 0x07,
	CCT_DQUOTE_LEFT		= 0x28,
	CCT_DQUOTE_RIGHT	= 0x29,
	CCT_DQUOTE_TEXT		= 0x2A,
	CCT_SQUOTE_LEFT		= 0x4B,
	CCT_SQUOTE_RIGHT	= 0x4C,
	CCT_SQUOTE_TEXT		= 0x4D,
	CCT_OTHER			= 0x0E,
	CCT_NULL			= 0x0F,

	CCTM_KEYWORD_MASK	= 0x10,	// ѤΥޥ
	CCTM_DQUOTE_MASK	= 0x20,
	CCTM_SQUOTE_MASK	= 0x40
};

// cե٥åȤݤȽǤ
template< typename T_Char >
bool IsAlphaNumeric( T_Char c )
{
#if LANGEXT_IS_ASCII
	return (
		c >= T_Char( 'A' ) && c <= T_Char( 'Z' ) ||
		c >= T_Char( 'a' ) && c <= T_Char( 'z' ) ||
		c >= T_Char( '0' ) && c <= T_Char( '9' ) ||
		c == T_Char( '_' )
	);
#else
	const char *p = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_0123456789";
	while ( (*p) ) {
		if ( T_Char( (*p) ) == c ) return true;
		++p;
	}
	return false;
#endif
}

template < typename T_Char, typename T_Ptr >
class CProgPtr
{
public:
	// ƥȤκǽΰ֤ꤹ
	CProgPtr( T_Ptr args, T_Ptr arge ) :
		sptr( args ), eptr( arge ), CurCharCnt( 0 ), CurPtr( args ), CurType( CCT_OTHER )
	{
		next();
	};

	// λˡƥȤꤹ
	CProgPtr( T_Ptr args, T_Ptr arge, CURCHARTYPE argType ) :
		sptr( args ), eptr( arge ), CurCharCnt( 1 ), CurPtr( args ), CurType( argType )
	{
		if ( argType == CCT_COM1_RIGHT && (*CurPtr) == T_Char( '*' ) )
			CurCharCnt = 2;
		if ( argType == CCT_COM1_LEFT && (*CurPtr) == T_Char( '/' ) )
			CurCharCnt = 2;
	};

	CProgPtr( const CProgPtr &r ) :
		sptr( r.sptr ), eptr( r.eptr ), CurCharCnt( r.CurCharCnt ), CurPtr( r.CurPtr ), CurType( r.CurType )
	{};

	// ˿ʤ
	bool next()
	{
		CURCHARTYPE wType;
		int wCnt;
		T_Ptr p2;
		bool IsEsc;

		// ǤݥȤƤ顢ʾˤϿʤʤ
		if ( CurPtr == eptr ) return false;

		// ݥ󥿤ʤ
		for ( int i = 0; i < CurCharCnt; i++ )
			++CurPtr;

		if ( CurPtr == eptr ) {
			// ƥȤã
			CurType = CCT_NULL;
			CurCharCnt = 0;
			return true;
		}

		p2 = CurPtr;
		++p2;

		// ưʸȽ
		JdgCharType( (*CurPtr), (*p2), &wType, &wCnt, &IsEsc );

		switch ( CurType & ~CCTM_KEYWORD_MASK ) {
		case CCT_ALPHANUMERIC:
		case CCT_OTHER:
		case CCT_COM1_RIGHT:
		case CCT_COM2_RIGHT:
		case CCT_DQUOTE_RIGHT:
		case CCT_SQUOTE_RIGHT:
			if ( wType != CCT_COM1_RIGHT ) {
				CurType = wType;
				CurCharCnt = wCnt;
			}
			else {
				// ǡ*/и
				CurType = CCT_OTHER;
				CurCharCnt = 1;
			}
			break;

		case CCT_COM1_LEFT:
		case CCT_COM1_TEXT:
			if ( wType != CCT_COM1_RIGHT ) {
				CurType = CCT_COM1_TEXT;
				CurCharCnt = 1;
			}
			else {
				CurType = CCT_COM1_RIGHT;
				CurCharCnt = 2;
			}
			break;

		case CCT_COM2_LEFT:
		case CCT_COM2_TEXT:
			CurCharCnt = 1;
			if ( (*CurPtr) != T_Char( '\n' ) )
				CurType = CCT_COM2_TEXT;
			else
				CurType = CCT_COM2_RIGHT;
			break;

		case CCT_DQUOTE_LEFT:
		case CCT_DQUOTE_TEXT:
			if ( wType == CCT_DQUOTE_LEFT ) {
				CurType = CCT_DQUOTE_RIGHT;
				CurCharCnt = 1;
			}
			else {
				CurType = CCT_DQUOTE_TEXT;
				CurCharCnt = ( IsEsc ? 2 : 1 );
			}
			break;

		case CCT_SQUOTE_LEFT:
		case CCT_SQUOTE_TEXT:
			if ( wType == CCT_SQUOTE_LEFT ) {
				CurType = CCT_DQUOTE_RIGHT;
				CurCharCnt = 1;
			}
			else {
				CurType = CCT_SQUOTE_TEXT;
				CurCharCnt = ( IsEsc ? 2 : 1 );
			}
			break;
		}
		return true;
	}

	// ʸμ̤Ƚ
	void JdgCharType( T_Char c1, T_Char c2, CURCHARTYPE *pType, int *pCnt, bool *pIsEsc )
	{
		(*pIsEsc) = false;

		if ( IsAlphaNumeric( c1 ) ) {
			(*pType) = CCT_ALPHANUMERIC;
			(*pCnt) = 1;
			return ;
		}

		if ( c1 == T_Char( '\\' ) ) {
			(*pType) = CCT_OTHER;
			if ( c2 == T_Char( '\0' ) )
				(*pCnt) = 1;	// ƥ\
			else {
				(*pCnt) = 2;	// \ǥפ줿ʸ
				(*pIsEsc) = true;
			}
			return ;
		}

		if ( c1 == T_Char( '\"' ) ) {
			(*pType) = CCT_DQUOTE_LEFT;
			(*pCnt) = 1;
			return ;
		}

		if ( c1 == T_Char( '\'' ) ) {
			(*pType) = CCT_SQUOTE_LEFT;
			(*pCnt) = 1;
			return ;
		}

		if ( c1 == T_Char( '/' ) && c2 == T_Char( '/' ) ) {
			(*pType) = CCT_COM2_LEFT;
			(*pCnt) = 2;
			return ;
		}

		if ( c1 == T_Char( '/' ) && c2 == T_Char( '*' ) ) {
			(*pType) = CCT_COM1_LEFT;
			(*pCnt) = 2;
			return ;
		}

		if ( c1 == T_Char( '*' ) && c2 == T_Char( '/' ) ) {
			(*pType) = CCT_COM1_RIGHT;
			(*pCnt) = 2;
			return ;
		}

		(*pType) = CCT_OTHER;
		(*pCnt) = 1;
	}

	// ߤʸμ̤򼨤
	CURCHARTYPE GetCurType() const
	{
		return CurType;
	}
	// ݥ󥿤
	T_Ptr GetPtr() const
	{
		return CurPtr;
	};

	// ߥݥȤƤʸʸ
	int GetCurCharCnt() const
	{
		return CurCharCnt;
	};

	// 
	bool operator ==( const CProgPtr &r ) const {
		return ( sptr == r.sptr && eptr == r.eptr && CurPtr == r.CurPtr );
	};
	bool operator ==( const T_Ptr &r ) const {
		return ( CurPtr == r );
	};

private:
	T_Ptr sptr;
	T_Ptr eptr;
	T_Ptr CurPtr;
	CURCHARTYPE CurType;
	int CurCharCnt;	// ߥݥȤƤʸʸ鹽뤫
};


///////////////////////////////////////////////////////////////////////////
// CHighlightMgr C++ץιʸĴɽԤ

template < typename T_Char, typename T_TxtPtr, typename T_CBPtr, typename T_KeywordList >
class CHighlightMgr_cpp
{
public:
	CHighlightMgr_cpp(){};
	virtual ~CHighlightMgr_cpp(){};

	// Ƥο򹹿
	void FullUpdate( T_TxtPtr pSTxt, T_TxtPtr pETxt, T_CBPtr pSCB ) const
	{
		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ
		PartryUpdate( CProgPtr< T_Char, T_TxtPtr >( pSTxt, pETxt ), pSCB, true, pSTxt );
	};

	// ѹȼ
	void UpdateWidthChange(
		T_TxtPtr pSTxt,		// ƥȻü
		T_TxtPtr pETxt,		// ƥü
		T_TxtPtr pUpdateSPosTxt,	// ѹϰ
		T_CBPtr pUpdateSPosCB,		// ѹϰ֤Υ顼Хåե
		T_TxtPtr pUpdateEPosTxt		// ѹλ
		) const
	{
		// öäƤ顢ʤ
		// ɤޤ뤫->ѹսľʸʸ˰¸
		// ѿ	ѿʳʸޤ
		// 	ʳʸޤ
		// 	ʸ
		// ʸ	ʸʳ⤷\ʳε
		// ɤޤǿʤफ->ʸѹʤʤޤ

		if ( pSTxt == pETxt ) return ;	// ƥĹ0ʤФϤʤ

		T_TxtPtr wTxtPtr = pUpdateSPosTxt;
		T_CBPtr wCBPtr = pUpdateSPosCB;
		if ( !( wTxtPtr == pSTxt ) ) {
			// 
			--wCBPtr;
			--wTxtPtr;
			switch ( (*wCBPtr) ) {
			case CCT_ALPHANUMERIC:
			case CCT_KEYWORD:
				while ( !( wTxtPtr == pSTxt ) && ( (*wCBPtr) & ~CCTM_KEYWORD_MASK ) == CCT_ALPHANUMERIC ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case CCT_COM1_LEFT:
			case CCT_COM1_RIGHT:
				// CCT_COM1_RIGHT̵Ȥޤ
				/*while ( !( wTxtPtr == pSTxt ) && ( (*wCBPtr) & ~CCTM_KEYWORD_MASK ) == CCT_COM1_RIGHT ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;*/
			case CCT_COM1_TEXT:
			case CCT_COM2_LEFT:
			case CCT_COM2_RIGHT:
			case CCT_COM2_TEXT:
				if ( !( wTxtPtr == pSTxt ) ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case CCT_DQUOTE_LEFT:
			case CCT_DQUOTE_RIGHT:
			case CCT_DQUOTE_TEXT:
				while ( !( wTxtPtr == pSTxt ) && ( (*wCBPtr) & CCTM_DQUOTE_MASK ) && (*wTxtPtr) == '\\' ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case CCT_SQUOTE_LEFT:
			case CCT_SQUOTE_RIGHT:
			case CCT_SQUOTE_TEXT:
				while ( !( wTxtPtr == pSTxt ) && ( (*wCBPtr) & CCTM_SQUOTE_MASK ) && (*wTxtPtr) == '\\' ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case CCT_OTHER:
				while ( !( wTxtPtr == pSTxt ) && (*wCBPtr) == CCT_OTHER ) {
					--wCBPtr;
					--wTxtPtr;
				}
				break;
			case CCT_NULL:
				return ;
			}
		}

		// ʤ
		unsigned char uc = (*wCBPtr);
		CProgPtr< T_Char, T_TxtPtr > ptr( wTxtPtr, pETxt, (CURCHARTYPE)uc );
		if ( wTxtPtr == pSTxt ) ptr = CProgPtr< T_Char, T_TxtPtr >( pSTxt, pETxt );	// ǽ餫鹹
		PartryUpdate( ptr, wCBPtr, false, pUpdateEPosTxt );	// ʸ郎
	};

private:
	// 򹹿
	// flg˿ꤷϡpETxtޤǹ롣
	// ꤷϡpOvTxtʸѹʤʤޤǹ
	void PartryUpdate( CProgPtr< T_Char, T_TxtPtr > ptr, T_CBPtr pSCB, bool flg, T_TxtPtr pOvTxt ) const
	{
		T_CBPtr pColorBuf = pSCB;
		int wType;
		int OldType;
		int i;
		bool OverFlg = flg;

		OldType = (*pSCB);
		wType = ~OldType;	// Ȥꤢ
		while ( ptr.GetCurType() != CCT_NULL && ( flg || OldType != wType || !OverFlg ) )
		{
			OldType = (*pColorBuf);	// ѹʸ
// printf( "\'%c\' : %d 0x%02X \n", *(ptr.GetPtr()), ptr.GetCurCharCnt(), OldType );

			if ( ptr.GetCurType() == CCT_ALPHANUMERIC )
				wType = LoopKeyword( &ptr, &pColorBuf );	// ѻͤξϡɤβǽ
			else {
				// pColorBufꤹͤꤹ
				wType = ptr.GetCurType();
				// pColorBufͤꤹ
				for ( i = 0 ; i < ptr.GetCurCharCnt(); i++ ) {
					OldType = (*pColorBuf);	// ѹʸ
					(*pColorBuf) = wType;
					++pColorBuf;
				}
				ptr.next();
			}
			// ݥ󥿤pOvTxtۤݤ
			if ( ptr.GetPtr() > pOvTxt ) OverFlg = true;
		}
	};

	// ɤݤȽǤꤹ
	CURCHARTYPE LoopKeyword( CProgPtr< T_Char, T_TxtPtr > *pPtr, T_CBPtr *pColorBuf ) const
	{
		CKeywordFinder< T_Char > Finder( &( KeywordList.GetKeywordList() ) );
		int i, j;
		T_CBPtr hpCB = (*pColorBuf);
		CURCHARTYPE wType;
		CURCHARTYPE SetType;

		// ɤθʤĤġꤹϰϤꤹ
		i = 0;
		wType = pPtr->GetCurType();
		while ( wType != CCT_NULL && wType == CCT_ALPHANUMERIC ) {

			// ǽ̵ɤ
			Finder.AddChar( *(pPtr->GetPtr()) );

			// ʸ
			for ( j = 0; j < pPtr->GetCurCharCnt(); j++ )
				++(*pColorBuf);
			i++;
			pPtr->next();
			wType = pPtr->GetCurType();
		}

		// ꤹ뿧ꤹ
		if ( Finder.IsFound() )
			SetType = CCT_KEYWORD;	// ɤǤ
		else
			SetType = CCT_ALPHANUMERIC;	// ɤǤϤʤ

		// ꤷϰϤ˿ꤹ
		while ( !( hpCB == (*pColorBuf) ) ) {
			(*hpCB) = SetType;
			++hpCB;
		}
		return SetType;
	};

protected:
	T_KeywordList KeywordList;
};

} // namespace NLangExt_cpp

} // namespace NLangExt

#endif // HIGHLIGHTMGR_CPP_H_INCLUDED_
