////////////////////////////////////////////////////////////////////////////
// CFileReader 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "FileReader.h"
#include "TaEditShell.h"
#include "../lib/Alias.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CFileReader::CFileReader() :
	pData( NULL ),
	EnableExitFlg( false ),
	IsModifiedFlg( false ),
	InterruptFlg( false ),
	ErrorInfo(),
	CProcesingObj()
{

}

CFileReader::~CFileReader()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// 
void CFileReader::SetInfo( const string &argFN, const CEncodeInfo &argE, T_LineData *argD )
{
	FileName = argFN;
	EncodeInfo = argE;
	pData = argD;
	EnableExitFlg = false;
	IsModifiedFlg = false;
	InterruptFlg = false;
}

// ɤ߹ѥåɤΥȥݥ
void CFileReader::run()
{
	FILE *file;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// ꤵ줿եΥ󥳡ɤѴ
	file = TranseFile();
	if ( file == NULL ) {
		EnableExitFlg = true;
		return ;
	}

	if ( fflush( file ) ) {
		fclose( file );
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		EnableExitFlg = true;
		return ;
	}
	if ( fseek( file, 0, SEEK_SET ) ) {
		fclose( file );
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		EnableExitFlg = true;
		return ;
	}

	// եɤ߹
	ReadFile( file );
}

// ɤ߹˥󥳡ɤѴ
// ե֤
FILE* CFileReader::TranseFile()
{
	FILE *outfile = NULL;
	char *pConvPath;
	string cmd;
	int r;
	string InputEncode;
	string OutputEncode;
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();

	// 󥳡̾
	InputEncode = EncodeInfo.GetEncodeName();
	OutputEncode = nl_langinfo( CODESET );

	// ѴץΥѥ
	pConvPath = getenv( SCEV_CONVERTER_PATH );
	if ( NULL == pConvPath ) {
		// ѴץबꤵƤʤäϡ
		// ʤ̤˥ե򳫤֤
		outfile = fopen( FileName.c_str(), "r" );
		if ( NULL == outfile ) {
			ErrorInfo = CErrorBool( pConf->RefIOErrorMsg( errno ) );
			return NULL;
		}
		return outfile;
	}

	// ΰե򳫤
	outfile = tmpfile();
	if ( NULL == outfile ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		return NULL;
	}

	// ѴѤΥޥɤ
	cmd = pConvPath;
	cmd += " -ifc " + InputEncode + " -ofc " + OutputEncode;
	cmd += " -ifn " + FileName + " -c LF";
	cmd += " -t 2>&1";

	// եȡɸϤؤ
	if ( !GlbFunc::SwapPort( stdout, outfile ) ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		fclose( outfile );
		return NULL;
	}

	// Ѵ¹
	r = system( cmd.c_str() );

	// եȡɸϤؤ
	if ( !GlbFunc::SwapPort( stdout, outfile ) ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		fclose( stdout );
		fclose( outfile );	// ɸϤĤƤޤޤ
		return NULL;
	}

	// ޥɤμ¹Է̤Ƚ
	if ( r < 0 ) {
		ErrorInfo = CErrorBool( pConf->RefFailedToStartEncConvMsg() );
		fclose( outfile );
		return NULL;
	}
	r = WEXITSTATUS( r );
	if ( r != 0 ) {
		switch ( r ) {
		case 2:
			ErrorInfo = CErrorBool( pConf->RefEncodeNameIsInvalidMsg() );
			break;
		default:
			ErrorInfo = CErrorBool( pConf->RefFailedToConvertEncodeMsg() );
			break;
		}
		fclose( outfile );
		return NULL;
	}

	return outfile;
}

// եɤ߹
void CFileReader::ReadFile( FILE* infile )
{
	wchar_t wc[ TA_MAX_LINE_SIZE + 1 ];
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	bool NewLineFlg; // Ǹɤ߹Ԥ˲ԥɤޤޤƤݤݻ

	EnableExitFlg = false;
	IsModifiedFlg = false;
	InterruptFlg = false;
	ErrorInfo = true;

	pData->clear();	// ǡ򥯥ꥢ
	IsModifiedFlg = true;
	NewLineFlg = false;
	while ( !feof( infile ) && !ferror( infile ) && !InterruptFlg ) {

		// ɤ߹
		if ( !fgetws( wc, TA_MAX_LINE_SIZE + 1, infile ) ) break;

		size_t wc_len = wslen( wc );	// ʸĹ

		// ɤ߹Ԥ˲ԥɤĤƤ뤫ݤ
		if ( L'\n' == wc[ wc_len - 1 ] ) {
			wc[ wc_len - 1 ] = L'\0';	// ԥɤĤƤ
			NewLineFlg = true;		// ե饰ꤹ
			wc_len--;
		}
		else
			NewLineFlg = false;

		// ԤĹγǧ
		if ( wc_len >= TA_MAX_LINE_SIZE ) {
			ErrorInfo = CErrorBool( pConf->RefBrokenLineMsg() );
			break;
		}

		// ꥹȤ˹Ԥɲ
		pData->push_back( wc );
	}
	if ( ferror( infile ) )
		ErrorInfo = CErrorBool( pConf->RefIOErrorMsg( errno ) );

	fclose( infile );

	// Ǹɤ߹Ԥ˲ԥɤޤޤƤ硢
	// ⤷ϰԤɤ߹Ǥʤˤ
	// ιԤդäɬפ
	if ( NewLineFlg || pData->size() == 0 ) pData->push_back( L"" );

	EnableExitFlg = true;
}

// λǽݤ
bool CFileReader::EnableExit() const
{
	return EnableExitFlg;
}

// 
void CFileReader::Interrupt()
{
	InterruptFlg = true;
}

// 顼
CErrorBool CFileReader::GetErrorInfo() const
{
	return ErrorInfo;
}

// ѹݤ
bool CFileReader::IsModified() const
{
	return IsModifiedFlg;
}

