////////////////////////////////////////////////////////////////////////////
// CNegCmd 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include <stdlib.h>
#include <assert.h>
#include <unistd.h>
#include <sys/types.h>
#include <fcntl.h>

#include "NegCmd.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CNegCmd::CNegCmd( const char *pStr, int len )
{
	int DataLen;
	if ( len < 4 ) return ;

	// Ƭ4ХȤˤϥǡĹϿƤ
	memcpy( &DataLen, pStr, sizeof( int ) );
	pStr += sizeof( int ) / sizeof ( char );

	// ºݤΥǡͿ줿Хåեû礬
	if ( DataLen < len ) len = DataLen;

	Recognize( pStr, len );
}

// ǥץǡ
CNegCmd::CNegCmd( int fd )
{
	char Buf[512];
	const int BufLen = sizeof( Buf ) / sizeof( Buf[0] );
	int len;
	int DataLength;
	string wstr;

	// ǡĹ
	DataLength = 0;
	len = read( fd, &DataLength, sizeof( int ) );
	if ( len < 0 ) return ;

	// ǡ
	len = 0;
	wstr = "";
	while ( len < DataLength ) {
		int r = read( fd, Buf, BufLen );
		if ( r < 0 ) break;
		len += r;
		wstr += string( Buf, r );
	}

	// Ϳ줿Х᤹
	Recognize( wstr.c_str(), wstr.length() );
}

CNegCmd::CNegCmd()
{
	mapCmd.clear();
}

CNegCmd::CNegCmd( const CNegCmd& r ) :
	mapCmd( r.mapCmd )
{
}

CNegCmd::~CNegCmd()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ǡϤ
bool CNegCmd::Recognize( const char *pStr, int len )
{
	const char *wp = pStr;
	int ID;
	int DataLen;
	string data;
	bool r = true;

	mapCmd.clear();

	while ( len > 0 ) {
		// ID
		if ( !GetInt( wp, len, &ID ) ) goto ERR_EXIT;
		len -= sizeof( int );
		wp += sizeof( int );
		// ǡĹ
		if ( !GetInt( wp, len, &DataLen ) ) goto ERR_EXIT;
		len -= sizeof( int );
		wp += sizeof( int );
		// ǡĹǧ
		if ( len < DataLen ) goto ERR_EXIT;
		// mapɲ
		AddData( ID, wp, DataLen );
		len -= DataLen;
		wp += DataLen;
	}
	r = true;

	return r;

ERR_EXIT:
	mapCmd.clear();
	return false;
}

// 4ХȤοͥǡ
bool CNegCmd::GetInt( const char *pStr, int len, int *val ) const
{
	int i;

	assert( this && val && pStr );
	if ( len < sizeof( int ) ) return false;

	memcpy( val, pStr, sizeof( int ) );
	return true;
}

// ͤ
int CNegCmd::GetData( int ID, int def ) const
{
	map< int, string >::const_iterator itr = mapCmd.find( ID );
	if ( itr != mapCmd.end() )
		return atoi( itr->second.c_str() );
	else
		return def;
}

// ʸͤ
const string& CNegCmd::GetData( int ID, const string& def ) const
{
	map< int, string >::const_iterator itr = mapCmd.find( ID );
	if ( itr != mapCmd.end() )
		return itr->second;
	else
		return def;
}

// CNegCmd
vector< CNegCmd > CNegCmd::GetData( int ID, const vector< CNegCmd > &def ) const
{
	string s;
	vector< CNegCmd > rv;
	CNegCmd wNegCmd;
	int i, j, cnt;
	const char *wp;

	// IDͤ򸡺
	s = GetData( ID, "" );
	if ( s.length() < sizeof( int ) ) return def;
	wp = s.begin();

	// ǿ
	if ( !GetInt( wp, s.end() - wp, &cnt ) ) return def;
	wp += sizeof( int );

	// ʸ
	for ( i = 0; i < cnt; i++ ) {
		if ( wp >= s.end() ) return def;

		// ʸĹ
		if ( !GetInt( wp, s.end() - wp, &j ) ) return def;
		wp += sizeof( int );

		// ʸᤷơɲ
		if ( j > s.end() - wp ) return def;
		rv.push_back( CNegCmd( wp, j ) );
		wp += j;
	}

	return rv;
}

// ꤵ줿IDΥǡ¸ߤ뤫ݤ
bool CNegCmd::HasData( int ID ) const
{
	map< int, string >::const_iterator itr = mapCmd.find( ID );
	return ( itr != mapCmd.end() );
}

// ͤɲ
void CNegCmd::AddData( int ID, const void *pData, int DataLen )
{
	// IDΥǡǤϿƤϡΥǡ
	map< int, string >::iterator itr = mapCmd.find( ID );
	if ( itr != mapCmd.end() ) mapCmd.erase( itr );

	// ɲä
	string wstr( reinterpret_cast< const char* >( pData ), DataLen );
	mapCmd.insert( pair< int, string >( ID, wstr ) );
}
void CNegCmd::AddData( int ID, const char *pData )
{
	AddData( ID, pData, strlen( pData ) );
}
void CNegCmd::AddData( int ID, const string& rData )
{
	AddData( ID, rData.c_str(), rData.length() );
}
void CNegCmd::AddData( int ID, int d )
{
	char buf[30];
	int len;

	snprintf( buf, 30, "%d", d );
	len = strlen( buf );
	AddData( ID, buf, sizeof( char ) * len );
}
void CNegCmd::AddData( int ID, const vector< CNegCmd > &vec )
{
	char buf[ sizeof( int ) ];
	int i, j;
	string r, w;

	// ƬǿϢ뤹
	i = vec.size();
	memcpy( buf, &i, sizeof( int ) );
	r = string( buf, sizeof( int ) );

	for ( i = 0; i < vec.size(); i++ ) {
		// Ϣ뤹ʸ
		w = vec[i].GetSendData();
		// ʸĹϢ뤹
		j = w.length();
		memcpy( buf, &j, sizeof( int ) );
		r += string( buf, sizeof( int ) );
		// ʸϢ뤹
		r += w;
	}

	AddData( ID, r );
}

// ʸ
string CNegCmd::GetSendData() const
{
	char buf[ sizeof( int ) ];
	int i;
	map< int, string >::const_iterator itr;
	string r;

	r = "";
	for ( itr = mapCmd.begin(); itr != mapCmd.end(); itr++ ) {
		// ID
		i = itr->first;
		memcpy( buf, &i, sizeof( int ) );
		r += string( buf, sizeof( int ) );
		// ʸĹ
		i = itr->second.length();
		memcpy( buf, &i, sizeof( int ) );
		r += string( buf, sizeof( int ) );
		// ʸ
		r += itr->second;
	}

	// Ƭ˥ǡĹϢ뤹
	i = r.length();
	memcpy( buf, &i, sizeof( int ) );
	r = string( buf, sizeof( int ) ) + r;

	return r;
}

// 
const CNegCmd& CNegCmd::operator =( const CNegCmd &r )
{
	mapCmd = r.mapCmd;
	return (*this);
}

// 
void CNegCmd::Initialize()
{
	mapCmd.clear();
}

