/********************************************************************/
/* Copyright (c) 2019 System fugen G.K.                             */
/* All rights reserved.                                             */
/********************************************************************/

#include "stdafx.h"
#include "fugenView.h"
#include "mgModelessDialogue.h"

/////////////////////////////////////////////////////////////////////////////
// mgModelessDialogue parent _CAO implementation.
// mgModelessDialogue is used as a parent modeless dialog.

IMPLEMENT_DYNAMIC(mgModelessDialogue, CDialog)

mgModelessDialogue::mgModelessDialogue(MGCommandBase* tool)
:CDialog(), m_commandTool(tool){
}

BOOL mgModelessDialogue::OnInitDialog(){
	if(!CDialog::OnInitDialog())
		return FALSE;
	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	// _CAO\ʒu̒
	CPoint point;
	::GetCursorPos(&point);
	SetWindowPos(&wndTop, point.x, point.y, 0, 0, SWP_NOSIZE);
	return TRUE;
}

void mgModelessDialogue::PostNcDestroy() {
	// [hX_CAOȂ̂ delete this B
	delete this;
}

void mgModelessDialogue::OnOK(){
	MGCommandBase* tool= m_commandTool;
	if(tool)
		tool->document()->normalEnd_command_tool(tool, 1);
}

void mgModelessDialogue::OnCancel(){
	MGCommandBase* tool = m_commandTool;
	if(tool)	// R}hLZIƂB
		tool->document()->cancel_command_tool(tool, 1);
}

BOOL mgModelessDialogue::DestroyWindow(){
	if(m_commandTool){
		m_commandTool->setModelessDialogPointer(nullptr);
		m_commandTool->get_main_view()->SetFocus();
	}
	m_commandTool = nullptr;
	return CWnd::DestroyWindow();
}

BEGIN_MESSAGE_MAP(mgModelessDialogue, CDialog)
END_MESSAGE_MAP()
