/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#if !defined(AFX_GLVIEW2D_H__8613C83B_63AC_4E4E_9C52_8AA56D97554F__INCLUDED_)
#define AFX_GLVIEW2D_H__8613C83B_63AC_4E4E_9C52_8AA56D97554F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "fugenView.h"

/////////////////////////////////////////////////////////////////////////////
// fugenView2D r[

class fugenView2D : public fugenView{

	DECLARE_DYNCREATE(fugenView2D)

protected:

	fugenView2D();
	fugenView2D(
		int coord_type,	//coordinate type: 0:(x,y), 1:(y,z), 2:(x,z) out of (x,y,z).
		char axis1='u',		//axis name of axis1.
		char axis2='v'		//axis name of axis2.
		);

public:

	// Axis name.
	const CString& axis1() const{ return m_axis1;};
	const CString& axis2() const{ return m_axis2;};
	int coord_type()const{return m_coord_type;};

	virtual void copy_view_env(const fugenView& other);

	///display the (x,y,z) position in status bar.
	virtual void display_position_in_status_bar(const MGPosition& point) const;

	///Return if this is a 2D view or not.
	virtual bool is_2D() const{return true;}

	///Wr[|[go[̂ЂƂŃo[̕\ύX̔f
	///󂯕t邩ǂ. TRUÊ̂̂ꂩЂƂłꂽ\ւ
	///ύXfugenDoc̃f[^ʂTRUÊׂẴr[ɔfB
	///Function's return value is:0(false) if not standard view.
	///1: 3D perspective view, 2:(x,y) 2D view, 3:(y,z) 2D view, 4:(z,x) 2D view
	virtual int is_standard_view()const{return 0;};
	
	////// Wn̕` //////
	void updateAxisPictures(float scale=1.f);

	/// Apply construction plane's colors.
	/// Must be override View2D etc.
	virtual void apply_grid_colors(MGContext& cxt);

// I[o[Ch
	// ClassWizard ͉z֐̃I[o[Ch𐶐܂B

	//{{AFX_VIRTUAL(fugenView2D)
	//}}AFX_VIRTUAL

	// Cve[V
protected:
	virtual ~fugenView2D();

	///Initialize model.
	virtual void initializeModel();

	///Transform to the view whose origin is cplane's origin and
	//whose eys is on the normal of the cplane.
	virtual void cplaneHome();

	virtual void mouse_move_transform(const CPoint& point);
	
	///Set the window title.
	void setTitle();

	//Get the view title of this view;
	virtual CString viewTitle()const;

	// ꂽbZ[W }bv֐
protected:
	//{{AFX_MSG(fugenView2D)
	afx_msg void OnUpdateViewVolumePlan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVolumeFront(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVolumeBack(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVolumeBottom(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVolumeLeft(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVolumeRight(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVolumeTop(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewVolumePerspective(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

private:
	//display the (u,v) position in status bar.
	void display_uv_in_status_bar(const MGPosition& point) const;

	//coordinate kind of this 2D view.
	// 0:(x,y), 1:(y,z), 2:(x,z). All of these coordinate type is 
	//displayed in PaneText as
	//"x 1234567.123 y 1234567.123 z 1234567.123"
	//When m_coord_type=3, coordinate type regarding to the model matrix is 
	//treated as m_coord_type=0, and the coordinated value is displayed as
	//"m_axis1 1234567.123 m_axis2 1234567.123"
	int m_coord_type;
	CString m_axis1, m_axis2;
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ ͑Os̒Oɒǉ̐錾}܂B

#endif // !defined(AFX_GLVIEW2D_H__8613C83B_63AC_4E4E_9C52_8AA56D97554F__INCLUDED_)
