/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// ZebraDlg.cpp : Cve[V t@C

#include "stdafx.h"
#include "ZebraDlg.h"
#include "EvalCmd/EvalSurfZebraTool.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CZebraDlg _CAO


CZebraDlg::CZebraDlg(MGEvalSurfZebraTool* tool)
:mgModelessDialogue(tool){
	//{{AFX_DATA_INIT(CZebraDlg)
	m_edB = 255;
	m_edG = 0;
	m_edR = 0;
	m_radio = 0;
	m_dThick = 0.1f;
	//}}AFX_DATA_INIT
	m_bModified = FALSE;
	Create(IDD_ZEBRA_DLG);
}


void CZebraDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CZebraDlg)
	DDX_Control(pDX, IDC_ZEBRA_SLIDER_R, m_sldR);
	DDX_Control(pDX, IDC_ZEBRA_SLIDER_G, m_sldG);
	DDX_Control(pDX, IDC_ZEBRA_SLIDER_B, m_sldB);
	DDX_Text(pDX, IDC_ZEBRA_EDIT_R, m_edR);
	DDV_MinMaxByte(pDX, m_edR, 0, 255);
	DDX_Text(pDX, IDC_ZEBRA_EDIT_G, m_edG);
	DDV_MinMaxByte(pDX, m_edG, 0, 255);
	DDX_Text(pDX, IDC_ZEBRA_EDIT_B, m_edB);
	DDV_MinMaxByte(pDX, m_edB, 0, 255);
	DDX_Radio(pDX, IDC_ZEBRA_RADIO_V, m_radio);
	DDX_Text(pDX, IDC_ZEBRA_EDIT_THICKNESS, m_dThick);
	//}}AFX_DATA_MAP
}

BOOL CZebraDlg::PreTranslateMessage(MSG* pMsg){
	// Eat WM_MOUSEWHEEL message.
	switch (pMsg->message){
    case WM_MOUSEWHEEL:
		return -1;
	}
	return CDialog::PreTranslateMessage(pMsg);
}

BEGIN_MESSAGE_MAP(CZebraDlg, mgModelessDialogue)
	//{{AFX_MSG_MAP(CZebraDlg)
	ON_WM_HSCROLL()
	ON_EN_KILLFOCUS(IDC_ZEBRA_EDIT_R, OnKillfocusEditR)
	ON_EN_KILLFOCUS(IDC_ZEBRA_EDIT_G, OnKillfocusEditG)
	ON_EN_KILLFOCUS(IDC_ZEBRA_EDIT_B, OnKillfocusEditB)
	ON_EN_UPDATE(IDC_ZEBRA_EDIT_R, OnUpdateEdit)
	ON_EN_UPDATE(IDC_ZEBRA_EDIT_G, OnUpdateEdit)
	ON_EN_UPDATE(IDC_ZEBRA_EDIT_B, OnUpdateEdit)
	ON_BN_CLICKED(IDC_ZEBRA_RADIO_H, OnZebraRadio)
	ON_EN_UPDATE(IDC_ZEBRA_EDIT_THICKNESS, OnUpdateEdit)
	ON_BN_CLICKED(IDC_ZEBRA_RADIO_V, OnZebraRadio)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CZebraDlg bZ[W nh

void CZebraDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) {
	m_edR = m_sldR.GetPos();
	m_edG = m_sldG.GetPos();
	m_edB = m_sldB.GetPos();
	UpdateData(FALSE);
	
	m_bModified = TRUE;
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
	UpdateView();
}

BOOL CZebraDlg::OnInitDialog() {
	mgModelessDialogue::OnInitDialog();

	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	m_sldR.SetRange(0, 255);
	m_sldG.SetRange(0, 255);
	m_sldB.SetRange(0, 255);
	
	m_sldR.SetPageSize(16);
	m_sldG.SetPageSize(16);
	m_sldB.SetPageSize(16);

	m_sldR.SetPos(m_edR);
	m_sldG.SetPos(m_edG);
	m_sldB.SetPos(m_edB);

	CRect rect;
	AfxGetMainWnd()->GetWindowRect(rect);
	int r = rect.right, b = rect.bottom;
	GetClientRect(rect);
	r -= rect.Width();
	b -= rect.Height();

	CPoint point;
	::GetCursorPos(&point);
	SetWindowPos(&wndTop, r, b, 0, 0, SWP_NOSIZE);

	return TRUE;
}

void CZebraDlg::OnKillfocusEditR(){
	if(!UpdateData()){
		m_edR = m_sldR.GetPos();
		UpdateData(FALSE);
		return;
	}

	m_sldR.SetPos(m_edR);
	UpdateView();
}

void CZebraDlg::OnKillfocusEditG(){
	if(!UpdateData()){
		m_edG = m_sldG.GetPos();
		UpdateData(FALSE);
		return;
	}

	m_sldG.SetPos(m_edG);
	UpdateView();
}

void CZebraDlg::OnKillfocusEditB(){
	if(!UpdateData()){
		m_edB = m_sldB.GetPos();
		UpdateData(FALSE);
		return;
	}

	m_sldB.SetPos(m_edB);
	UpdateView();
}

void CZebraDlg::OnUpdateEdit(){
	m_bModified = TRUE;
}

void CZebraDlg::OnZebraRadio(){
	m_bModified = TRUE;
	UpdateView();
}

void CZebraDlg::UpdateView(){
	if(IsModified()){
		UpdateData();
		MGEvalSurfZebraTool* tool=getEvalSurfZebraTool();
		if(tool){
			tool->draw_pictures(
				GetColor(), GetThickness(), IsVertical()==TRUE);
		}
		SetModifiedFlag(FALSE);
	}
}

MGEvalSurfZebraTool* CZebraDlg::getEvalSurfZebraTool(){
	return static_cast<MGEvalSurfZebraTool*>(getCmdTool());
}
