/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// ViewZoomDynamicTool.h: MGZoomDynamicTool NX̃C^[tFCX

#if !defined(AFX_ZOOMDYNAMICTOOL_H__9FCEB503_C7A6_483C_B05F_512B3F607B86__INCLUDED_)
#define AFX_ZOOMDYNAMICTOOL_H__9FCEB503_C7A6_483C_B05F_512B3F607B86__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"

class CCameraAction;

/// class MGViewZoomDynamicTool
///
/// Zooms with the left mouse button.
/// Hold down the left mouse button and drag up and down with the in the viewport to zoom in and out.
class MGViewZoomDynamicTool : public MGCommandBase
{
	HCURSOR m_hCursor; ///< Y[pJ[\\[X
	bool m_bTracking; ///< }EXɂ鑀쒆ۂ
	int m_center[2]; ///< cneter of the zoom in screen coordinate(of left bottom is the origin).
	std::unique_ptr<CCameraAction> m_spAction; ///< J

public:
	explicit MGViewZoomDynamicTool(fugenDoc* pDoc);

	virtual bool can_break_into() const{ return true;}

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);

	virtual bool OnLButtonDown(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnLButtonUp(fugenView* window, CPoint old_point,UINT nFlags, CPoint point);
	virtual bool OnMouseMove(fugenView* window,UINT nFlags, CPoint point);
	virtual bool OnSetCursor(fugenView* pView, CWnd* pWnd, UINT nHitTest, UINT message);
};

#endif // !defined(AFX_ZOOMDYNAMICTOOL_H__9FCEB503_C7A6_483C_B05F_512B3F607B86__INCLUDED_)
