/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// ViewZoomDynamicTool.cpp: MGViewZoomDynamicTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "ViewCmd/ViewZoomDynamicTool.h"
#include "Undo/CameraAction.h"
#include "Misc/UserPreference.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGViewZoomDynamicTool

MGViewZoomDynamicTool::MGViewZoomDynamicTool(fugenDoc* pDoc)
	:MGCommandBase(pDoc, ID_VIEW_ZOOM_DYNAMIC),
	  m_hCursor(0),
	  m_bTracking(false)
{
}

MGCommandBase* MGViewZoomDynamicTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGViewZoomDynamicTool(pDoc);
}

bool MGViewZoomDynamicTool::initiate_tool(){
	MGCommandBase::initiate_tool();
	VERIFY(m_hCursor = ::AfxGetApp()->LoadCursor(IDC_CURSOR_ZOOM));

	SetStatusMessage(IDS_PROMPT_ZOOM_DYNAMIC);
	return false;
}

bool MGViewZoomDynamicTool::terminate_tool(bool cancel)
{
	if(m_spAction.get()){
		m_spAction.reset();
	}

	m_bTracking = false;
	::ReleaseCapture();

	return MGCommandBase::terminate_tool(cancel);
}

bool MGViewZoomDynamicTool::OnLButtonDown(fugenView* pView, UINT, CPoint point)
{
	m_bTracking = true;
	pView->change_sc(point,m_center[0],m_center[1]);

	// JñJ̏ԂۑB
	// Memento p^[ŌƂ createMemento B
	m_spAction.reset(new CCameraAction(pView));
	m_spAction->SaveEnvParam(IAction::ACTION_UNDO);

	SetStatusMessage(IDS_PROMPT_ZOOM_DYNAMIC);
	return false;
}

bool MGViewZoomDynamicTool::OnLButtonUp(fugenView* pView, CPoint, UINT, CPoint point)
{
	if(m_bTracking){
		// JIƂ݂ȂāAŏIJԂۑB
		m_spAction->Do(); //  Do() āASetLastAction ݂̂sB
		m_spAction->SaveEnvParam(IAction::ACTION_REDO);

		// ANV̏L ActionManager Ɉς˂B
		m_spAction.release();

		m_bTracking = false;
		::ReleaseCapture();
	}
	return OnCommandEnd(1);
}

bool MGViewZoomDynamicTool::OnMouseMove(fugenView* pView,UINT nFlags,CPoint point)
{
	if(m_bTracking){
		pView->SetCapture();

		int diff = pView->mousemove_old_point().y - point.y; // WnWindows
		if(diff==0){
			return false;
		}

		UserPreference& pref = UserPreference::getInstance();
		double ds = pref.GetDoubleValue(upv_ViewOp_ScaleDelta);
		if(0 < ds && ds < 1.){
			ds = 1./ds;
		}
		pView->scale(diff > 0 ? ds : 1./ ds, m_center);
		pView->redrawOnlythis();
	}
	return MGCommandBase::OnMouseMove(pView,nFlags,point);
}

bool MGViewZoomDynamicTool::OnSetCursor(
	fugenView* pView,
	CWnd* pWnd,
	UINT nHitTest,
	UINT message)
{
	if(m_bTracking && m_hCursor){
		::SetCursor(m_hCursor);
		return true;
	}

	// NX OnSetCursor ɔCB
	return MGCommandBase::OnSetCursor(pView, pWnd, nHitTest, message);
}
