/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// RotateTool.cpp: MGViewRotateTool NX̃Cve[V

#include "stdafx.h"
#include "ViewCmd/ViewRotateTool.h"
#include "Undo/CameraAction.h"
#include "fugenView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGViewRotateTool

MGViewRotateTool::MGViewRotateTool(fugenDoc* pDoc)
	 : MGCommandBase(pDoc, ID_VIEW_ROTATE),
	   m_hCursor(0),
	   m_bTracking(false)
{
}

MGCommandBase* MGViewRotateTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGViewRotateTool(pDoc);
}

bool MGViewRotateTool::initiate_tool(){
	MGCommandBase::initiate_tool();

	VERIFY(m_hCursor = AfxGetApp()->LoadCursor(IDC_CURSOR_ROTATE));
	SetStatusMessage(IDS_PROMPT_VIEW_ROTATE);
	return false;
}

bool MGViewRotateTool::terminate_tool(bool cancel)
{
	if(m_spAction.get()){
		m_spAction.reset();
	}
	m_bTracking = false;
	return MGCommandBase::terminate_tool(cancel);
}

bool MGViewRotateTool::OnLButtonDown(fugenView* pView, UINT, CPoint point)
{
	m_bTracking = true;

	// JñJ̏ԂۑB
	// Memento p^[ŌƂ createMemento B
	m_spAction.reset(new CCameraAction(pView));
	m_spAction->SaveEnvParam(IAction::ACTION_UNDO);

	SetStatusMessage(IDS_PROMPT_VIEW_ROTATE);
	return false;
}

bool MGViewRotateTool::OnLButtonUp(fugenView* pView, CPoint, UINT, CPoint point)
{
	if(m_bTracking){
		// JIƂ݂ȂāAŏIJԂۑB
		m_spAction->Do(); //  Do() āASetLastAction ݂̂sB
		m_spAction->SaveEnvParam(IAction::ACTION_REDO);

		// ANV̏L ActionManager Ɉς˂B
		m_spAction.release();

		m_bTracking = false;
		::ReleaseCapture();
	}
	return OnCommandEnd(1);
}

bool MGViewRotateTool::OnMouseMove(fugenView* pView, UINT nFlags, CPoint point)
{
	if(m_bTracking){
		pView->SetCapture();
		pView->mouse_move_transform(point);
		pView->redrawOnlythis();
	}
	return false;
}

bool MGViewRotateTool::OnSetCursor(
	fugenView* pView,
	CWnd* pWnd,
	UINT nHitTest,
	UINT message)
{
	if(m_bTracking && m_hCursor){
		::SetCursor(m_hCursor);
		return true;
	}

	// NX OnSetCursor ɔCB
	return MGCommandBase::OnSetCursor(pView, pWnd, nHitTest, message);
}
