/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// PanTool.cpp: MGViewPanTool NX̃Cve[V

#include "stdafx.h"
#include "fugenDoc.h"
#include "fugenView.h"
#include "ViewCmd/ViewPanTool.h"
#include "Undo/CameraAction.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGViewPanTool

MGViewPanTool::MGViewPanTool(fugenDoc* pDoc)
	 : MGCommandBase(pDoc, ID_VIEW_PAN),
	   m_hCursor(0),
	   m_bTracking(false)
{
}

MGCommandBase* MGViewPanTool::initial_clone(fugenDoc* pDoc) const
{
	return new MGViewPanTool(pDoc);
}

bool MGViewPanTool::initiate_tool(){
	MGCommandBase::initiate_tool();
	VERIFY(m_hCursor = ::AfxGetApp()->LoadCursor(IDC_CURSOR_PAN));
	SetStatusMessage(IDS_PROMPT_VIEW_PAN);
	return false;
}

bool MGViewPanTool::terminate_tool(bool cancel)
{
	if(m_spAction.get()){
		m_spAction.reset();
	}
	m_bTracking = false;
	::ReleaseCapture();

	return MGCommandBase::terminate_tool(cancel);
}

bool MGViewPanTool::OnLButtonDown(fugenView* pView, UINT, CPoint point)
{
	m_bTracking = true;

	// JñJ̏ԂۑB
	// Memento p^[ŌƂ createMemento B
	m_spAction.reset(new CCameraAction(pView));
	m_spAction->SaveEnvParam(IAction::ACTION_UNDO);

	SetStatusMessage(IDS_PROMPT_VIEW_PAN);
	return false;
}

bool MGViewPanTool::OnLButtonUp(fugenView* pView, CPoint, UINT, CPoint point){
	if(m_bTracking){
		// JIƂ݂ȂāAŏIJԂۑB
		m_spAction->Do(); //  Do() āASetLastAction ݂̂sB
		m_spAction->SaveEnvParam(IAction::ACTION_REDO);

		// ANV̏L ActionManager Ɉς˂B
		m_spAction.release();

		m_bTracking = false;
		::ReleaseCapture();
	}
	return OnCommandEnd(1);
}

bool MGViewPanTool::OnMouseMove(fugenView* pView, UINT nFlags, CPoint point){
	if(m_bTracking){
		pView->SetCapture();
		pView->pan(pView->mousemove_old_point(),point);
		pView->redrawOnlythis();
	}
	return MGCommandBase::OnMouseMove(pView,nFlags,point);
}

bool MGViewPanTool::OnSetCursor(
	fugenView* pView,
	CWnd* pWnd,
	UINT nHitTest,
	UINT message)
{
	if(m_bTracking && m_hCursor){
		::SetCursor(m_hCursor);
		return true;
	}

	// NX OnSetCursor ɔCB
	return MGCommandBase::OnSetCursor(pView, pWnd, nHitTest, message);
}
