/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#pragma once
#include "mg/Attrib.h"
#include "mgGL/Name.h"
#include "mgGL/glViewAttrib.h"

class MGOpenGLView;

/// @class MGNamedViewItem NamedViewItem.h "ViewCmd/NamedViewItem.h"
/// uOtr[vR}hŕۑ邽߂̃f[^NXB
class MGNamedViewItem : public MGAttrib
{
	MGName m_name; ///< O
	MGglViewAttrib m_env; ///< J

public:
	/// identify_type p̒lB
	enum{ TID = MGATTRIB_TID | 0x00FF0001};

	/// ftHgRXgN^[
	/// @post m_name.empty()
	MGNamedViewItem();

	/// Oƒlw肵ăIuWFNgB
	/// @param[in] name ݒ̖
	/// @param[in] env r[̏
	/// @post m_name == name
	///       m_env == env
	MGNamedViewItem(const CString& name, const MGglViewAttrib& env);

	/// Oƒlw肵ăIuWFNgB
	/// @param[in] name ݒ̖
	/// @param[in] view r[ MGOpenGLView o[f[^B
	/// @post m_name == name
	MGNamedViewItem(const CString& name, const MGOpenGLView& view);

	/// Rs[RXgN^[ɂN[IuWFNgԂB
	/// @return N[IuWFNg
	virtual MGNamedViewItem* clone() const;

	///draw attribute data.
	virtual void drawAttrib(
		mgVBO& vbo,///<The target graphic object.
		bool no_color = false	///<if true, color attribute will be neglected.
	)const override{		;	};

	/// @return TID
	virtual long identify_type() const;

	/// Xg[ɂóB
	/// @param[in,out] s o̓Xg[
	/// @return s
	virtual std::ostream& toString(std::ostream& ostrm) const;

	/// ̃NX̂ԂB
	/// @return  "MGNamedViewItem"
	virtual std::string whoami() const;

	/// ݒ薼̂ԂB
	/// @return m_name
	const MGName& name() const;

	/// ݒ薼̂ZbgB
	/// @post name == m_name
	void set_name(const CString& name);

	/// r[ԂB
	/// @return m_env
	const MGglViewAttrib& view_env() const;

	/// r[ԂB
	/// @post m_env == view
	void set_view_env(const MGglViewAttrib& view);

	/// MGOpenGLView Ƀr[ZbgB
	void set_view_env(const MGOpenGLView& view);

protected:
	virtual void ReadMembers(MGIfstream& s);
	virtual void WriteMembers(MGOfstream& s) const;
};
