********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
#include "stdafx.h"
#include "fugen.h"
#include "ViewCmd/NamedCPlaneItem.h"
#include "mg/GelFactory.h"
#include "mg/Ifstream.h"
#include "mg/Ofstream.h"
#include "mgGL/OpenGLView.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

AUTO_GEL_REGISTER(MGNamedCPlaneItem, MGNamedCPlaneItem::TID);

namespace{
	const UINT NAMED_VIEW_ITEM_VERSION = 1;
}

MGNamedCPlaneItem::MGNamedCPlaneItem(){
}

MGNamedCPlaneItem::MGNamedCPlaneItem(const CString& name, const MGPlane& plane)
:m_plane(plane){
	std::string nm = CT2A(name);
	m_name=MGName(nm);
}

MGNamedCPlaneItem* MGNamedCPlaneItem::clone() const{
	return new MGNamedCPlaneItem(*this);
}

long MGNamedCPlaneItem::identify_type() const{
	return TID;
}

std::ostream& MGNamedCPlaneItem::toString(std::ostream& ostrm) const{
	ostrm<<"MGNamedCPlaneItem:"<<m_name<<std::endl;
	ostrm<<","<<m_plane;
	return ostrm;
}

void MGNamedCPlaneItem::ReadMembers(MGIfstream& s){
	UINT nVersion;
	s >> nVersion;
	if(nVersion > NAMED_VIEW_ITEM_VERSION){
		// Vo[W̃t@CǂݍƂĂB
		// B
	}
	m_name.ReadMembers(s);

	//m_plane.ReadMembers(s);

	MGPosition p;
	p.restore(s);
	
	MGVector u, v;
	u.restore(s);
	v.restore(s);

	m_plane = MGPlane(u, v, p);
}

void MGNamedCPlaneItem::WriteMembers(MGOfstream& s) const{
	s << NAMED_VIEW_ITEM_VERSION;
	m_name.WriteMembers(s);

	//m_plane.WriteMembers(s);

	m_plane.root_point().dump(s);
	m_plane.u_deriv().dump(s);
	m_plane.v_deriv().dump(s);
}

std::string MGNamedCPlaneItem::whoami() const
{
	return "MGNamedCPlaneItem";
}

const MGName& MGNamedCPlaneItem::name() const
{
	return m_name;
}

void MGNamedCPlaneItem::set_name(const CString& name)
{
	std::string nm = CT2A(name);
	m_name=MGName(nm);
}

const MGPlane& MGNamedCPlaneItem::plane() const
{
	return m_plane;
}

void MGNamedCPlaneItem::set_plane(const MGPlane& plane)
{
	m_plane = plane;
}
