/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/**
 * @file CPlaneUtil.h
 * @brief ƕʃR}hŗp鋤ʊ֐
 */
#pragma once

struct IPlaneActionTarget;
class MGConstructionPlane;
class MGPosition;
class MGPlane;
class mgSysGL;
class fugenView;

/** ƕʂ̃vr[̂߁AOpenGL ֐ĂԁB
 *  @param[in] cpl ҏWƕʁB
 *  @param[in] org ƕʂ̌_̈ړ̈ʒuB
 *  @param[in] xend ƕʂ X [i_łȂقj̈ړ̈ʒuB
 *  @param[in] yend ƕʂ Y [i_łȂقj̈ړ̈ʒuB
 *  @param[in] zColor ƕʂ Z ̐FwB=nullptr̂Ƃ`悵ȂB
 *  @param[in] draw_displacement _̕ψʂ⏕ŕ`悷Ȃ true ZbgB
 *
 *  @throws O͓ȂB
 *
 *  pƂẮAR}hNX do_make_temporary_display
 *   PreviewCPlane ֐ĂяoƂɂȂ邾낤B
 */

//Draw a temporal construction plane.
//The cplane to draw is the plane whose origin is org, and...
void PreviewCPlane(
	mgSysGL& vbo,
	const MGConstructionPlane& cplane,
		///<Input the old cplane, whose origin and attributes
		///<are used to draw the new construction plane.
	const MGPosition& org,
	const MGVector& xDir,
	const MGVector& yDir,
	const MGColor* zColor=nullptr,
		//Indicates if the normal line from the origin is necessary to draw.
		//If zColor!=nullptr, draw the line with the color zColor.
	bool draw_displacement=true
		//Indicates if the line from cpl.origin() to org is necessary to draw.
		//If draw_displacement is true, draw the displacement line.
);

/// CPlane ҏWp⏕֐
/// @param[in,out] pTarget ҏWΏۂ̍ƕʂB
/// @param[in] uderi ƕʂU
/// @param[in] vderi ƕʂV
/// @param[in] origin ƕʂ̌_
void ExecPlaneAction(
	IPlaneActionTarget* pTarget,
	const MGVector& uderi,
	const MGVector& vderi,
	const MGPosition& origin
);

/// CPlane ҏWp⏕֐
/// @param[in,out] pTarget ҏWΏۂ̍ƕʂB
/// @param[in] plNew ҏW̍ƕʂ̌``B
void ExecPlaneAction(
	IPlaneActionTarget* pTarget,
	const MGPlane& plNew
);

///Translation of CPlane to toPoint.
void execCPlaneTranslateAction(
		fugenView* view,
		const MGPosition& toPoint
);

/// Get the rotation angle from axes[(rotation_axis+1)%3] to the vector
/// (crsr-orign) around the normal axes[rotation_axis].
double getAngleUAxis(
	const MGPosition& crsr,	//Input the cursor position
	const MGPosition origin,
	int rotation_axis,
	const MGVector axes[3]
);
