/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneTop.cpp
 * @brief CPlaneTop.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "ViewCmd/CPlaneTop.h"
#include "ViewCmd/CPlaneUtil.h"
#include "fugenView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// MGCPlaneTopTool

MGCPlaneTopTool::MGCPlaneTopTool(fugenDoc* pDoc)
: MGCommandBase(pDoc, ID_CPLANE_TOP),
m_pView(pDoc->get_main_view()){
}

MGCommandBase* MGCPlaneTopTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCPlaneTopTool(pDoc);
}

bool MGCPlaneTopTool::initiate_tool(){
	MGCommandBase::initiate_tool();

	ASSERT(m_pView);
	ExecPlaneAction(m_pView, mgX_UVEC, mgY_UVEC, mgORIGIN);
	setActiveView(m_pView);
	return OnCommandEnd(1);
}
