/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CPlaneToView.cpp
 * @brief CPlaneToView.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "ViewCmd/CPlaneToView.h"
#include "ViewCmd/CPlaneUtil.h"
#include "fugenView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// MGCPlaneToViewTool

MGCPlaneToViewTool::MGCPlaneToViewTool(fugenDoc* pDoc)
	 : MGCommandBase(pDoc, ID_CPLANE_TO_VIEW),
	   m_pView(theApp.currentfugenView(pDoc))
{
}

MGCommandBase* MGCPlaneToViewTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCPlaneToViewTool(pDoc);
}

bool MGCPlaneToViewTool::initiate_tool(){
	ASSERT(m_pView);
	MGCommandBase::initiate_tool();

	fugenDoc& doc = *document();
	const MGBox& bx=doc.box();

	MGConstructionPlane& cpl=m_pView->cplane();
	cpl.setGridDataByBox(bx, m_pView->is_standard_view(),getUserPrefGridColor());
	ExecPlaneAction(m_pView, cpl.plane());

	return OnCommandEnd(1);
}
