/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneRight.cpp
 * @brief CPlaneRight.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "ViewCmd/CPlaneRight.h"
#include "ViewCmd/CPlaneUtil.h"
#include "fugenView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// MGCPlaneRightTool

MGCPlaneRightTool::MGCPlaneRightTool(fugenDoc* pDoc)
: MGCommandBase(pDoc, ID_CPLANE_RIGHT),
m_pView(pDoc->get_main_view()){
}

MGCommandBase* MGCPlaneRightTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCPlaneRightTool(pDoc);
}

bool MGCPlaneRightTool::initiate_tool(){
	MGCommandBase::initiate_tool();

	ASSERT(m_pView);
	ExecPlaneAction(m_pView, mgY_UVEC, mgZ_UVEC, mgORIGIN);
	setActiveView(m_pView);
	return OnCommandEnd(1);
}
