/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file CPlaneOrigin.h
 * @brief NX MGCPlaneOriginTool ̐錾
 */
#if !defined(AFX_CPLANEORIGIN_H__A23C769A_2B27_4572_AE1D_5BAEDCE9C9B4__INCLUDED_)
#define AFX_CPLANEORIGIN_H__A23C769A_2B27_4572_AE1D_5BAEDCE9C9B4__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/LocateState.h"

/// @class MGCPlaneOriginTool CPlaneOrigin.h "ViewCmd/CPlaneOrigin.h"
///
/// Changes the construction plane origin to pass through given point.
class MGCPlaneOriginTool : public MGLocateState{
public:
	explicit MGCPlaneOriginTool(fugenDoc* pDoc);
	explicit MGCPlaneOriginTool(fugenView* pView);

	// default : false (not break)
	virtual bool can_break_into() const{ return true;}

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& info);

	/////////////////functions for draw_temporary()////////////
	void do_make_temporary_display(mgSysGL& sgl,fugenView* pSView);

private:
	fugenView* m_pView; // ΏۂƂȂr[
	const MGColor* m_zColor;//Color of CPlane's normal.
};

#endif // !defined(AFX_CPLANEORIGIN_H__A23C769A_2B27_4572_AE1D_5BAEDCE9C9B4__INCLUDED_)
