/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file CPlaneAxisZ.cpp
 * @brief CPlaneAxisZ.h ̎
 */
#include "stdafx.h"
#include "fugen.h"
#include "fugenView.h"
#include "ViewCmd/CPlaneUtil.h"
#include "ViewCmd/CPlaneAxisZ.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// class MGCPlaneAxisZTool
///]:@YɁAV@w
///Vm[}w肵ACPlanẽm[}YƂ悤]

MGCPlaneAxisZTool::MGCPlaneAxisZTool(fugenDoc* pDoc)
: MGLocateState(pDoc,ID_CPLANE_Z,NO_RUBBER,POINTLINE_IPDRAW),
m_pView(pDoc->get_main_view()),
m_N(m_pView->cplane().plane().normal()),
m_v(m_N){
	const MGContext& ctx=*(pDoc->context());
	const MGColor* gridColors=ctx.gridColors();
	m_zColor=&gridColors[3];
}

MGCPlaneAxisZTool::MGCPlaneAxisZTool(fugenView* pView)
: MGLocateState(pView->GetDocument(),ID_CPLANE_Z,NO_RUBBER,POINTLINE_IPDRAW),
m_pView(pView->document().get_main_view()),
m_N(m_pView->cplane().plane().normal()),
m_v(m_N){
	const MGContext& ctx=*(document()->context());
	const MGColor* gridColors=ctx.gridColors();
	m_zColor=&gridColors[3];
}

MGCommandBase* MGCPlaneAxisZTool::initial_clone(fugenDoc* pDoc)const{
	return new MGCPlaneAxisZTool(pDoc);
}

void MGCPlaneAxisZTool::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){
	const MGConstructionPlane& cplane = m_pView->cplane();
	switch(locates().size()){
	case 0:
		// ʏtranslation
		m_org = cursor();
		m_u = cplane.plane().u_deriv();
		break;
	case 1:
		{
			MGUnit_vector Nnew(cursor() - m_org);
			MGVector U=m_N*Nnew;
			Nnew.orthonormal(U, m_u, m_v);
		}
		break;
	}
	PreviewCPlane(sgl,cplane, m_org, m_u, m_v,m_zColor);
}

bool MGCPlaneAxisZTool::OnLocated(const MGLocateInfo& info){
	const LInfoVec& linfos=locates();	
	switch(linfos.size()){
	case 1:
		// CPlane ̌_
		m_org = linfos[0]->point_world();
	case 0:
		break;
	case 2:
		{
			// U&V
			const MGPosition& P0=linfos[0]->point_world();
			const MGPosition& P1=linfos[1]->point_world();
			MGUnit_vector Nnew(P1-P0);
			MGVector U=m_N*Nnew;
			Nnew.orthonormal(U, m_u, m_v);
		}

		// vZJn
		ExecPlaneAction(m_pView, m_u, m_v, m_org);	
		setActiveView(m_pView);
		return OnCommandEnd(1); // R}hI
	}
	return false;
}

void MGCPlaneAxisZTool::prompt_message() const{
	switch(locates().size()){
	case 0:
		SetStatusMessage(IDS_PROMPT_CPLANE_ORIGIN);
		break;
	case 1:
		SetStatusMessage(IDS_PROMPT_AXIS_Z);
		break;
	}
}
