/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
#pragma once
#include "Undo/ActionBase.h"
#include "mg/Plane.h"

struct IPlaneActionTarget;

/// @class CPlaneAction PlaneAction.h "Undo/PlaneAction.h"
///
/// NX CPlaneAction ͊er[ɎĂƕʂ̕ύX\B
/// r[x[X̃ANVȂ̂ŁAGelAction Ƃ͈قȂU镑B
class CPlaneAction : public CActionBase
{
	MGPlane m_plOld; ///< IWi̍ƕʂ̌`
	MGPlane m_plNew; ///< C̍ƕʂ̌`

public:
	/// W`RXgN^[
	/// @param[in] pView ƕʂr[B
	/// @param[in] pl ύX̍ƕʂ̊􉽏B
	CPlaneAction(IPlaneActionTarget* pView, const MGPlane& pl);

	/// fXgN^
	virtual ~CPlaneAction();

	virtual void Do();
	virtual void Redo();
	virtual void Undo();

	// TuNXŗL̃\bhQ

	IPlaneActionTarget* GetTargetView();

	/// IWi̍ƕ
	const MGPlane& GetOldPlane() const;
	void SetOldPlane(const MGPlane& pl);

	/// ύX̍ƕ
	const MGPlane& GetNewPlane() const;
	void SetNewPlane(const MGPlane& pl);

private:
	void updatePlaneView(const MGPlane& pl);
};
