/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
#include "stdafx.h"
#include "Undo/IPlaneActionTarget.h"
#include "Undo/PlaneAction.h"
#include "mgGL/ConstructionPlane.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CPlaneAction::CPlaneAction(IPlaneActionTarget* pTarget, const MGPlane& pl)
	 : CActionBase(pTarget), m_plNew(pl){
}

CPlaneAction::~CPlaneAction(){
}

void CPlaneAction::Do(){
	CActionBase::Do();
	updatePlaneView(GetNewPlane());
	GetActionTarget()->SetDirtyFlag();
}

void CPlaneAction::Redo(){
	CActionBase::Redo();
	updatePlaneView(GetNewPlane());
	GetActionTarget()->SetDirtyFlag();
}

void CPlaneAction::Undo(){
	updatePlaneView(GetOldPlane());
	CActionBase::Undo();
}

IPlaneActionTarget* CPlaneAction::GetTargetView(){
	return static_cast<IPlaneActionTarget*>(GetActionTarget());
}

const MGPlane& CPlaneAction::GetOldPlane() const{
	return m_plOld;
}

void CPlaneAction::SetOldPlane(const MGPlane& pl){
	m_plOld = pl;
}

const MGPlane& CPlaneAction::GetNewPlane() const{
	return m_plNew;
}

void CPlaneAction::SetNewPlane(const MGPlane& pl){
	m_plNew = pl;
}

void CPlaneAction::updatePlaneView(const MGPlane& pl){
	IPlaneActionTarget* pView = GetTargetView();
	if(pView){
		MGConstructionPlane& cplane = pView->GetCPlane();
		cplane.set_plane(pl);
		pView->Refresh(); // ЂƂ View  update Ώ\B
	}
}
