/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
#pragma once

#include <deque>

struct IAction;
struct IActionTarget;

/// @class IActionManager IActionManager.h "Undo/IActionManager.h"
/// UndoManager ̃C^[tFCX𒊏ۉĂB
///
/// IActionTarget NX IActionManager ێP[Xz肵ĂB
struct IActionManager
{
	enum StackKind{ UNDO, REDO };
	enum { UM_DEFAULT_STACK_CAPACITY = 25 };

	virtual ~IActionManager(){}

	virtual IActionTarget* GetTarget() const = 0;

	/// all targets must register; note that this routine
	/// can be called again to change the settings of a
	/// previously registered action target
	virtual void RegisterTarget(
		IActionTarget* pTarget,
		int nCapacity = UM_DEFAULT_STACK_CAPACITY) = 0;

	/// add an action to the action target's undo stack.
	virtual void SetLastAction(IAction* pAction = 0) = 0;

	/// undo the last n actions applied to an action target
	virtual void Undo(int nActions = 1) = 0;

	/// can we undo the last n actions?
	virtual bool CanUndo(int nActions = 1) const = 0;

	/// redo the last n undone actions
	virtual void Redo(int nActions = 1) = 0;

	/// can we redo the last n undone action?
	virtual bool CanRedo(int nActions = 1) const = 0;

	/// get the current size of a stack
	virtual int GetStackSize(StackKind kind) const = 0;

	/// get/set the maximum size of a stack (both stacks have same max)
	virtual int GetStackCapacity() const = 0;
	virtual void SetStackCapacity(int nActions) = 0;

	/// Delete all the actions stacked.
	virtual void DeleteActions()=0;
};
