/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GelReplaceAction.h: interface for the CGelReplaceAction class.
// This class serves as gel replace (== add and remove) action

#if !defined(__GELREPLACE_ACTION__)
#define __GELREPLACE_ACTION__

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Undo/DocAction.h"
#include "Undo/mgGelAction.h"

class fugenDoc;

class CGelReplaceAction : public CDocAction{
public:
	///RXgN^
	explicit CGelReplaceAction(fugenDoc* pDoc = 0);
	///RXgN^
	CGelReplaceAction(
		fugenDoc* pDoc, 
		const MGGelPositions& original,///<the original gels
		const MGGelPositions& modified ///<the gels to replace
		);
	///fXgN^
	virtual ~CGelReplaceAction();
	virtual void Do();
	virtual void Undo();
	virtual void Redo();

	///Push back (original, modified) as a pair into m_original and m_modified 
	void push_back(const MGGelPosition& original, const MGGelPosition& modified);

	///Update the views. This will be invoked by CDocAction::update_all_views,
	///when DO, Undo, or Redo operations are invoked.
	virtual void view_update(ACTION_TYPE at);

private:
	mgGelAction m_original;
	mgGelAction m_modified;

	// This class is neither copy-constructive nor assignable.
	CGelReplaceAction(const CGelReplaceAction&);
	CGelReplaceAction& operator=(const CGelReplaceAction&);

};

#endif // __GELREPLACE_ACTION__
