/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GelReplaceAction.cpp: implementation for the CReplaceAddAction class.
// This class serves as gel replace (== add and remove) action

#include "stdafx.h"
#include <set>
#include "mg/GelPositions.h"
#include "fugenView.h"
#include "Undo/GelReplaceAction.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGelReplaceAction::CGelReplaceAction(fugenDoc* pDoc)
: CDocAction(pDoc),m_original(pDoc),m_modified(pDoc){
}

CGelReplaceAction::CGelReplaceAction(
	fugenDoc* pDoc,
	const MGGelPositions& original,//the original gels
	const MGGelPositions& modified //the gels to replace
):CDocAction(pDoc),m_original(original,pDoc), m_modified(modified,pDoc){
}

CGelReplaceAction::~CGelReplaceAction(){
	fugenDoc& doc=*(actionTarget());

	if(in_redo_stack()){
		m_modified.delete_target_gels();
	}
	if(in_undo_stack()){
		m_original.delete_target_gels();
	}
}

void CGelReplaceAction::Do(){
	CDocAction::Do();
	m_original.delete_doc();
	m_modified.add_doc(false);
	update_all_views(ACTION_DO);
}

void CGelReplaceAction::Undo(){
	m_modified.delete_doc();
	m_original.add_doc(false);
	update_all_views(ACTION_UNDO);
	CDocAction::Undo();
}

void CGelReplaceAction::Redo(){
	CDocAction::Redo();
	m_original.delete_doc();
	m_modified.add_doc(false);
	update_all_views(ACTION_DO);
}

//Push back (original, modified) as a pair into m_original and m_modified 
void CGelReplaceAction::push_back(
	const MGGelPosition& original,
	const MGGelPosition& modified
){
	m_original.push_back_gelp(original);
	m_modified.push_back_gelp(modified);
}

//Update the views. This will be invoked by CDocAction::update_all_views,
//when DO, Undo, or Redo operations are invoked.
void CGelReplaceAction::view_update(ACTION_TYPE at){
	if(at==ACTION_DO || at==ACTION_REDO){
		m_original.replace_display_list(m_modified);
	}else{
		m_modified.replace_display_list(m_original);
	}
}
