/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GelRemoveAction.h: interface for the CGelRemoveAction class.
// This class serves as gel remove(delete) action
// It defines the following operations:
//
//		void Do();
//			--Notify the undo manager,
//			--Perform operation
//
//		void Undo();
//			-- add the deleted gels.
//
//		void Redo();
//			-- re-deletes the deleted gels.
//
//////////////////////////////////////////////////////////////////////

#if !defined(GelRemoveAction_H)
#define GelRemoveAction_H

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include "Undo/DocAction.h"
#include "Undo/mgGelAction.h"

class fugenDoc;

class CGelRemoveAction : public CDocAction{
public:
	///RXgN^
	explicit CGelRemoveAction(fugenDoc *doc=0);
	CGelRemoveAction(fugenDoc *doc, const MGGelPositions& gelp);
	///fXgN^
	virtual ~CGelRemoveAction();
	MGGelPositions& deleted(){return m_gelRemoved.target_gels();};

	virtual	void	Do();
	virtual	void	Undo();
	virtual	void	Redo();

	///Update the views. This will be invoked by CDocAction::update_all_views,
	///when DO, Undo, or Redo operations are invoked.
	virtual void view_update(ACTION_TYPE at);

private:
	mgGelAction m_gelRemoved;

};

#endif
