/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GelRemoveAction.cpp: implementation for the CGelRemoveAction class.
// This class serves as gel remove(delete) action
// It defines the following operations:
//
//		void Do();
//			--Notify the undo manager,
//			--Perform operation
//
//		void Undo();
//			-- add the deleted gels.
//
//		void Redo();
//			-- re-deletes the deleted gels.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Undo/GelRemoveAction.h"
#include "fugenView.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGelRemoveAction::CGelRemoveAction(fugenDoc *doc)
:CDocAction(doc),m_gelRemoved(doc){
}

CGelRemoveAction::CGelRemoveAction(fugenDoc *doc,const MGGelPositions& gelp)
:CDocAction(doc),m_gelRemoved(gelp,doc){
}

CGelRemoveAction::~CGelRemoveAction(){
	if(in_undo_stack())
		m_gelRemoved.delete_target_gels();
}

void CGelRemoveAction::Do(){
	CDocAction::Do();
	m_gelRemoved.delete_doc();
	update_all_views(ACTION_DO);
}

void CGelRemoveAction::Undo(){
	m_gelRemoved.add_doc(false);
	update_all_views(ACTION_UNDO);
	CDocAction::Undo();
}

void CGelRemoveAction::Redo(){
	CDocAction::Redo();
	m_gelRemoved.delete_doc();
	update_all_views(ACTION_REDO);
}

//Update the views. This will be invoked by CDocAction::update_all_views,
//when DO, Undo, or Redo operations are invoked.
void CGelRemoveAction::view_update(ACTION_TYPE at){
	if(at==ACTION_DO || at==ACTION_REDO){
		m_gelRemoved.delete_view();
	}else{
		m_gelRemoved.add_view();
	}
}
