/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
// GelAddAction.cpp: implementation for the CGelAddAction class.
// This class serves as gel add action
// It defines the following operations:
//
//		void Do();
//			--Notify the undo manager,
//			--Perform operation
//
//		void Undo();
//			-- delete the added gels.
//
//		void Redo();
//			-- re-add the added gels.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Undo/GelAddAction.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

CGelAddAction::CGelAddAction(fugenDoc *doc)
:CDocAction(doc),m_gelAdded(doc){
}

CGelAddAction::CGelAddAction(fugenDoc *doc, const MGGelPositions& gelps)
:CDocAction(doc),m_gelAdded(gelps,doc){
}

CGelAddAction::~CGelAddAction(){
	if(in_redo_stack())
		m_gelAdded.delete_target_gels();
}

void CGelAddAction::Do(){
	CDocAction::Do();
	m_gelAdded.add_doc(false);
	update_all_views(ACTION_DO);
}

void CGelAddAction::Undo(){
	m_gelAdded.delete_doc();
	update_all_views(ACTION_UNDO);
	CDocAction::Undo();
}

void CGelAddAction::Redo(){
	CDocAction::Redo();
	m_gelAdded.add_doc(false);
	update_all_views(ACTION_REDO);
}

//Update the views. This will be invoked by CDocAction::update_all_views,
//when DO, Undo, or Redo operations are invoked.
void CGelAddAction::view_update(ACTION_TYPE at){
	if(at==ACTION_DO || at==ACTION_REDO){
		m_gelAdded.add_view();
	}else{
		m_gelAdded.delete_view();
	}
}
