/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/* ***************************************************** */
/********************************************************************/
#pragma once
#include "Undo/ActionBase.h"

struct ICameraActionTarget;
class MGglViewAttrib;

/// @class CCameraAction CameraAction.h "Undo/CameraAction.h"
/// ̃NX̓Y[p̃JύXANV\B
class CCameraAction : public CActionBase{
	std::unique_ptr<MGglViewAttrib> m_spEnvOld; ///< Jݒ for Undo
	std::unique_ptr<MGglViewAttrib> m_spEnvNew; ///< Jݒ for Redo

public:
	/// RXgN^[
	/// @param[in] pView JύX\ȃr[B
	CCameraAction(ICameraActionTarget* pView);

	virtual ~CCameraAction();

	virtual void Do();
	virtual void Redo();
	virtual void Undo();

	// TuNXŗL̃\bhQ

	ICameraActionTarget* GetTargetView();

	/// JԂQƂB
	/// @param[in] actiontype UNDO p REDO pwB
	const MGglViewAttrib* GetEnvParam(ACTION_TYPE actiontype) const;

	/// ݂̃r[̃JԂo[f[^ɕۑB
	/// @param[in] actiontype UNDO p REDO pwB
	void SaveEnvParam(ACTION_TYPE actiontype);

private:
	void SetLastAction();

private:
	CCameraAction(const CCameraAction& other);
	CCameraAction& operator=(const CCameraAction& other);
};
