/********************************************************************/
/* Copyright (c) 2017 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// EvalSurfGauss.h: MGEvalSurfGauss NX̃C^[tFCX

#if !defined(AFX_EVALSURFGAUSS_H__F9F348B6_FE71_4774_8562_2C6624CD5C82__INCLUDED_)
#define AFX_EVALSURFGAUSS_H__F9F348B6_FE71_4774_8562_2C6624CD5C82__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Tl2/TL2Triangles.h"
#include "mgGL/SysGL.h"
#include "Common/SelectState.h"

class CGaussDlg;
class MGEvalSurfGaussToolSysGL;

// class MGEvalSurfGaussTool
//
// Analyze surface curvature (not only Gaussian).
class MGEvalSurfGaussTool : public MGSelectState{
public:
	explicit MGEvalSurfGaussTool(fugenDoc* pDoc);

	virtual bool can_break_into()const{return true;};
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	//virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true
	);

	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

	double minimum_curvature(
		MGCL::SURFACE_CURVATURE_KIND kind
	)const{return m_min_curvature[kind];};
	double maximum_curvature(
		MGCL::SURFACE_CURVATURE_KIND kind
	)const{return m_max_curvature[kind];};

	void draw_pictures(
		MGCL::SURFACE_CURVATURE_KIND kind,
		double dRangeMin,
		double dRangeMax);

	void draw_pictures(const MGPickObjects& surfs);

	/// eȗ́ivΏ۔͈͓́jŏlƍőlvZB
	/// _CAÓuv{^̏pɕKvB
	void ComputeExtrema(
		const MGPickObjects& surfs,
		std::vector<mgTL2Triangles>& tlds);

	//Get the pointer of the modeles Gauss dialog.
	CGaussDlg* getGaussDialog();

private:

	std::vector<MGEvalSurfGaussToolSysGL*> m_sysgl;

	double m_min_curvature[4];///<Minimum and maximum curvatures of the kind.
			///<  [0]: KEXȗ, [1]: ϋȗ, [2]: ŏȗ, [3]: őȗ
	double m_max_curvature[4];
			///<  [0]: KEXȗ, [1]: ϋȗ, [2]: ŏȗ, [3]: őȗ

	int m_nType; ///< MGCL::SURFACE_CURVATURE_KIND
};

class MGEvalSurfGaussToolSysGL: public mgSysGL
{
public:
	////////Special member functions/////////
	virtual ~MGEvalSurfGaussToolSysGL() = default;
	MGEvalSurfGaussToolSysGL(const MGEvalSurfGaussToolSysGL& sgaus2);
	MGEvalSurfGaussToolSysGL(MGEvalSurfGaussToolSysGL&& sgaus2);
	MGEvalSurfGaussToolSysGL& operator=(const MGEvalSurfGaussToolSysGL& sgaus2);
	MGEvalSurfGaussToolSysGL& operator=(MGEvalSurfGaussToolSysGL&& sgaus2);

	MGEvalSurfGaussToolSysGL(
		mgTL2Triangles&& tld,
		const MGGel* surf,
		MGCL::SURFACE_CURVATURE_KIND kind,
		double minimum,
		double maximum);

	// Note: this->m_tld ͋ɂȂB
	virtual mgSysGL* clone()const override;

	//Draw this Sysgl.
	//This draw is used to draw the pictures for Undo(, Redo) operations.
	virtual void drawSysGL();

	const MGGel* object_id() const{ return mgSysGL::object_id(); }

	//Release this mgTL2Triangles into trisNew.
	void release_tld(mgTL2Triangles&);

private:
	mutable mgTL2Triangles m_tld;
	MGCL::SURFACE_CURVATURE_KIND m_kind;
	double m_minimum;
	double m_maximum;
};

#endif // !defined(AFX_EVALSURFGAUSS_H__F9F348B6_FE71_4774_8562_2C6624CD5C82__INCLUDED_)
