/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// TransScale1D.h: MGTransScale1DTool NX̃C^[tFCX

#if !defined(AFX_TRANSSCALE1D_H__F847D9F4_67A2_459F_A567_DE17DDB996A1__INCLUDED_)
#define AFX_TRANSSCALE1D_H__F847D9F4_67A2_459F_A567_DE17DDB996A1__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

// class MGTransScale1DTool
//
// Scales objects in one dimension.
// The objects are expanded or contracted in the single direction specified,
// without expanding the objects in the other directions.
class MGTransScale1DTool : public MGCommandStateOwner{
	friend class MGTransScale1DIPoint;
	friend class MGTransScale1DSObj;

	int m_numDimension;///<scaling dimension. See calc_transformation's comment.
	double m_scalingFactor;

public:
	explicit MGTransScale1DTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

	bool makeModel(const MGTransf& tr);

///Get the transformation matrix that scales objects, whose scaling origin is
///P0=linfos[0]->point_world(), whose scaling direction are P1-P0
///(P1=linfos[1]->point_world()) and  Y if m_numDimenson=2.
///Here Y=N*(P1-P0)*Normal_of_the 1st located point's cplane.
///The scaling factor is obtained by (P1-P0).length/(P2-P1).length.
MGTransf calc_transform(const MGPosition& P2);
MGTransf calc_transform(double factor);

};

// class MGTransScale1DSObj
// 
// IuWFNg̑I
class MGTransScale1DSObj : public MGSelectState{
public:
	MGTransScale1DSObj(MGTransScale1DTool* owner);

	MGTransScale1DTool* state_owner(){
		return static_cast<MGTransScale1DTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
};

// class MGTransScale1DIPoint
// 
// XP[O̎QƓ_߂
class MGTransScale1DIPoint : public MGLocateState{
public:
	MGTransScale1DIPoint(MGTransScale1DTool* owner);

	MGTransScale1DTool* state_owner(){
		return static_cast<MGTransScale1DTool*>(get_owner_command());
	}
	const MGTransScale1DTool* state_owner()const{
		return static_cast<const MGTransScale1DTool*>(get_owner_command());
	}

	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	void prompt_message()const;
};


#endif // !defined(AFX_TRANSSCALE1D_H__F847D9F4_67A2_459F_A567_DE17DDB996A1__INCLUDED_)
