/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
// TransRotate3D.h: MGTransRotate3DTool NX̃C^[tFCX

#if !defined(AFX_TRANSROTATE3D_H__9C9BD33D_485A_4904_90BA_682599F97505__INCLUDED_)
#define AFX_TRANSROTATE3D_H__9C9BD33D_485A_4904_90BA_682599F97505__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

// class MGTransRotate3DTool
// 
// If]ړR}hB
// Ƃ͕ʂMGTransRotateToolƂNXB
class MGTransRotate3DTool : public MGCommandStateOwner{
public:
	explicit MGTransRotate3DTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();

private:
};

// class MGTransRotate3DSObj
//
// IuWFNgI
class MGTransRotate3DSObj : public MGSelectState{
public:
	MGTransRotate3DSObj(MGTransRotate3DTool* owner);

	MGTransRotate3DTool* state_owner(){
		return static_cast<MGTransRotate3DTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);

private:
	void prompt_message() const;
};

// class MGTransRotate3DIPoint
//
// QƓ_Cvbg
class MGTransRotate3DIPoint : public MGLocateState{
public:
	MGTransRotate3DIPoint(MGTransRotate3DTool* owner);

	MGTransRotate3DTool* state_owner(){
		return static_cast<MGTransRotate3DTool*>(get_owner_command());
	}
	const MGTransRotate3DTool* state_owner()const{
		return static_cast<const MGTransRotate3DTool*>(get_owner_command());
	}

	virtual bool OnKeyDown(fugenView* pView, UINT nChar, UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);

private:	
	void calculate(double angle);
	
	MGVector m_normal; //rotation axis.
	bool m_bCopy; // ϊ̃freplace/add̂ǂ炩

	bool is_copy_mode() const{ return m_bCopy; }
	void toggle_copy_mode(){ m_bCopy ^= true; }
	void prompt_message()const;
};


#endif // !defined(AFX_TRANSROTATE3D_H__9C9BD33D_485A_4904_90BA_682599F97505__INCLUDED_)
