/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

// TransRotate.h: MGTransRotateTool NX̃C^[tFCX

#if !defined(AFX_TRANSROTATETOOL_H__05013511_2385_425C_AABE_1BA9C56C4281__INCLUDED_)
#define AFX_TRANSROTATETOOL_H__05013511_2385_425C_AABE_1BA9C56C4281__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

// class MGTransRotateTool
//
// Rotates objects.
class MGTransRotateTool : public MGCommandStateOwner{
public:
	explicit MGTransRotateTool(fugenDoc* pDoc);
	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();


private:

	friend class MGTransRotateSObj;
	friend class MGTransRotateIPoint;
};

// class MGTransRotateSObj
// 
// IuWFNg̑I
class MGTransRotateSObj : public MGSelectState{
public:
	MGTransRotateSObj(MGTransRotateTool* owner);
	MGTransRotateTool* state_owner(){
		return static_cast<MGTransRotateTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);

private:
};

// class MGTransRotateIPoint
// 
// ]̎QƓ_߂
class MGTransRotateIPoint : public MGLocateState{
public:
	MGTransRotateIPoint(MGTransRotateTool* owner);

	MGTransRotateTool* state_owner(){
		return static_cast<MGTransRotateTool*>(get_owner_command());
	}
	const MGTransRotateTool* state_owner() const{
		return static_cast<const MGTransRotateTool*>(get_owner_command());
	}

	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	void prompt_message() const;

private:
	bool m_bCopy;

	char m_xyzchar[3];//Name of each axis.
	MGVector m_axes[3];	//axis vectors of the construction plane.
	MGVector m_Xaxis;//base axis to measure angle.
	int m_rotation_axis;	// rotation_axis, 0:u, 1:v, 2:N.

	void toggle_copy_mode(){ m_bCopy ^= true; }
	void calculate(double angle);
};

#endif // !defined(AFX_TRANSROTATETOOL_H__05013511_2385_425C_AABE_1BA9C56C4281__INCLUDED_)
