#pragma once
#include "EditCmd/EditRebuildTool.h"


// CSurfaceRebuildDlg _CAO

class CSurfaceRebuildDlg : public CDialog
{
	DECLARE_DYNAMIC(CSurfaceRebuildDlg)

public:
	CSurfaceRebuildDlg(MGRebuildTool* pParent);   // WRXgN^
	virtual ~CSurfaceRebuildDlg();
	void get_surf_param(
		int& splineApprox,//=0: no spline approximation,
						//  =1: reconstruct as NURBS(may be rational)
						//  =2: reconstruct as non rational B-Spline.
		int& reparameterize,//Indicates how the parameter normalization be done:
			//=0: no surface parameter normalization.
			//=1: normalize to u_range=(0., 1.), and v_range=(0.,1.);
			//=2: normalize to make the average length of the 1st derivative along u and v 
			//    of the base surface is as equal to 1. as possible(that is chord length).
			//=3: Specify surface parameter range in range[].
		double& surfTolerance,
		//int ordr[2],//u-order and v-order
		double range[4]//[0],[1] u start and end, [2],[3] v start and end.
	)const;

	void get_face_param(
		int& splineApprox,//=0: no spline approximation,
						//  =1: reconstruct as NURBS(may be rational)

						//  =2: reconstruct as non rational B-Spline.
		int& reparameterize,//Indicates how the parameter normalization be done:
			//=0: no surface parameter normalization.
			//=1: normalize to u_range=(0., 1.), and v_range=(0.,1.);
			//=2: normalize to make the average length of the 1st derivative along u and v 
			//    of the base surface is as equal to 1. as possible(that is chord length).
			//=3: Specify surface parameter range in range[].
		double& surfTolerance,
		//int ordr[2],//u-order and v-order
		double range[4],//[0],[1] u start and end, [2],[3] v start and end.
		//bool& edgeRebuild,
		bool& C1EdgeJoin
		//bool& removeShortEdg,
		//double& minimumEdgeLength
	)const;

// _CAO f[^
	enum { IDD = IDD_SURF_REBUILD_DLG };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV T|[g
	virtual BOOL OnInitDialog();

	DECLARE_MESSAGE_MAP()
private:
	MGRebuildTool* m_parentCMD;///Parent rebuild command
	//void enable_orderEdit(BOOL active);
	void enable_SEParamRange(BOOL active);
	//void enableMinimumEdgeLength(BOOL active);
	//void enableEdgeRebuild(BOOL active);

	// Tolerance allowed for the rebuid of the surface
	double m_SurfTolerance;

	// 0: non reparameterize, 1:[0,1] reparameterize, 2: Chord length reparameterize
	// 3: specify range.
	int m_reparameterize;

	double m_USparam;///< starting parameter value along u parameter line.
	double m_UEparam;///< ending parameter value along u parameter line.
	double m_VSparam;///< starting parameter value along v parameter line.
	double m_VEparam;///< ending parameter value along v parameter line.

	// true if change rational spline to non-rational spline(MGRSBRep to MGSBRep)
	BOOL m_nonRationalize;

	BOOL m_changeOrder;///< True to change order when the target surface is MGSPBRep.
	int m_orderU;///< order of u parameter
	int m_orderV;///< order of v parameter
	
	// True if short edges are to remove.
	BOOL m_edgeRebuild;
	
	// true if C1-continuous edges are to join.
	BOOL m_C1EJoin;

	// True if short edges are to remove.
	//BOOL m_shortEdgeRemove;

	//double m_minimum_edge_length;///<valid only when m_shortEdgeRemove is true, and
		/// indicates edges whose edge length are smaller than m_minimum_edge_length
		/// are to remove.

	afx_msg void OnBnClickedRadio0NoRepara();
	afx_msg void OnBnClickedRadio101repara();
	afx_msg void OnBnClickedRadio2ChordLength();
	afx_msg void OnBnClickedRadio3SpecifyRange();
	//afx_msg void OnBnClickedShortEdgeRemove();
	
public:
	//afx_msg void OnBnClickedCheckChangeOrder();
	afx_msg void OnBnClickedCheckNonRationalize();
	//afx_msg void OnStnClickedStaticSurfaceType();
	//afx_msg void OnBnClickedCheckC1edgeJoin();
};
