// SurfaceRebuildDlg.cpp : t@C
//

#include "stdafx.h"
#include "fugen.h"
#include "SurfaceRebuildDlg.h"
#include ".\surfacerebuilddlg.h"


// CSurfaceRebuildDlg _CAO

IMPLEMENT_DYNAMIC(CSurfaceRebuildDlg, CDialog)
CSurfaceRebuildDlg::CSurfaceRebuildDlg(MGRebuildTool* pParent)
	: CDialog(CSurfaceRebuildDlg::IDD)
	, m_parentCMD(pParent)
	, m_SurfTolerance(MGTolerance::line_zero())
	, m_USparam(0.)
	, m_UEparam(0.)
	, m_VSparam(0.)
	, m_VEparam(0.)
	, m_orderU(4)
	, m_orderV(4)
	, m_nonRationalize(FALSE)
	, m_changeOrder(FALSE)
	, m_reparameterize(2)
	, m_edgeRebuild(TRUE)
	, m_C1EJoin(TRUE)
	//, m_shortEdgeRemove(TRUE)
	//, m_minimum_edge_length(MGTolerance::line_zero()*10.)
{
}

CSurfaceRebuildDlg::~CSurfaceRebuildDlg(){
}

BOOL CSurfaceRebuildDlg::OnInitDialog(){
	CDialog::OnInitDialog();
	SetIcon(::AfxGetApp()->LoadIcon(IDR_MGCLTYPE), FALSE);

	//CSpinButtonCtrl* pSpinU = static_cast<CSpinButtonCtrl*>(GetDlgItem(IDC_SPIN_UORDER));
	//pSpinU->SetRange(2, 20);
	//CSpinButtonCtrl* pSpinV = static_cast<CSpinButtonCtrl*>(GetDlgItem(IDC_SPIN_VORDER));
	//pSpinV->SetRange(2, 20);

	//CButton* changeOrderButton = static_cast<CButton*>(GetDlgItem(IDC_CHECK_CHANGE_ORDER));
	CButton* nonRationalButton = static_cast<CButton*>(GetDlgItem(IDC_CHECK_NON_RATIONALIZE));
	MGSurface* srf=m_parentCMD->surface();

	m_SurfTolerance=double(int(m_SurfTolerance*10000000.))/10000000.;
	m_USparam=double(int(srf->param_s_u()*DECIMAL_PLACE_NUMBER))/DECIMAL_PLACE_NUMBER;
	m_UEparam=double(int(srf->param_e_u()*DECIMAL_PLACE_NUMBER))/DECIMAL_PLACE_NUMBER;
	m_VSparam=double(int(srf->param_s_v()*DECIMAL_PLACE_NUMBER))/DECIMAL_PLACE_NUMBER;
	m_VEparam=double(int(srf->param_e_v()*DECIMAL_PLACE_NUMBER))/DECIMAL_PLACE_NUMBER;
	//m_minimum_edge_length=double(int(m_minimum_edge_length*1000000.))/1000000.;

	//m_nonRationalize=FALSE;
	//m_changeOrder=FALSE;
	CString srftype;
	//enable_orderEdit(FALSE);
	if(m_parentCMD->sbrep()){
		srftype="Nonrational-BSpline-Surface";
		//changeOrderButton->EnableWindow(TRUE);
		nonRationalButton->EnableWindow(FALSE);
	}else if(m_parentCMD->rsbrep()){
		srftype="Rational-BSpline-Surface";
		//changeOrderButton->EnableWindow(FALSE);
		nonRationalButton->EnableWindow(TRUE);
	}else{
		srftype=CA2T(srf->whoami().c_str());
		//changeOrderButton->EnableWindow(FALSE);
		nonRationalButton->EnableWindow(FALSE);
	}
	CWnd* wintype = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_SURFACE_TYPE));
	wintype->SetWindowText(srftype);
	m_orderU=srf->order_u();
	m_orderV=srf->order_v();
	m_orderU=4;
	m_orderV=4;
	enable_SEParamRange(FALSE);

	if(m_parentCMD->face()){
		SetWindowText(_T("Face Rebuild"));
		//enableEdgeRebuild(TRUE);
	}else{
		SetWindowText(_T("Surface Rebuild"));
		CWnd* win= static_cast<CWnd*>(GetDlgItem(IDC_CHECK_C1EDGE_JOIN));
		win->EnableWindow(FALSE);
		//enableEdgeRebuild(FALSE);
	}

	UpdateData(FALSE);

	CPoint point;
	::GetCursorPos(&point);
	SetWindowPos(&wndTop, point.x, point.y, 0, 0, SWP_NOSIZE);

	return TRUE;
}

void CSurfaceRebuildDlg::DoDataExchange(CDataExchange* pDX){
	CDialog::DoDataExchange(pDX);

	DDX_Text(pDX, IDC_EDIT_TOL, m_SurfTolerance);
	DDV_MinMaxDouble(pDX, m_SurfTolerance, 0., 1e10);
	DDX_Radio(pDX, IDC_RADIO0_NO_REPARA, m_reparameterize);
	DDX_Text(pDX, IDC_EDIT_US, m_USparam);
	DDX_Text(pDX, IDC_EDIT_UE, m_UEparam);
	DDV_MinMaxDouble(pDX,m_UEparam,m_USparam,10.e+32);
	DDX_Text(pDX, IDC_EDIT_VS, m_VSparam);
	DDX_Text(pDX, IDC_EDIT_VE, m_VEparam);
	DDV_MinMaxDouble(pDX,m_VEparam,m_VSparam,10.e+32);

	DDX_Check(pDX, IDC_CHECK_NON_RATIONALIZE, m_nonRationalize);
	//DDX_Check(pDX, IDC_CHECK_CHANGE_ORDER, m_changeOrder);

	//DDX_Text(pDX, IDC_EDIT_UORDER, m_orderU);
	//DDV_MinMaxDouble(pDX, m_orderU, 2, 20);
	//DDX_Text(pDX, IDC_EDIT_VORDER, m_orderV);
	//DDV_MinMaxDouble(pDX, m_orderV, 2, 20);
	DDX_Radio(pDX, IDC_RADIO0_NO_REPARA, m_reparameterize);

	//DDX_Check(pDX, IDC_CHECK_EDGE_REBUILD, m_edgeRebuild);
	//if(m_edgeRebuild){
		DDX_Check(pDX, IDC_CHECK_C1EDGE_JOIN, m_C1EJoin);
	//	DDX_Check(pDX, IDC_CHECK_SHORT_EDGE_REMOVE, m_shortEdgeRemove);
	//	if(m_shortEdgeRemove){
	//		DDX_Text(pDX, IDC_EDIT_MIN_EDGE_LEN, m_minimum_edge_length);
	//		DDV_MinMaxDouble(pDX, m_minimum_edge_length, 0., 1e10);
	//	}
	//}
}

/*void CSurfaceRebuildDlg::enable_orderEdit(BOOL active){
	CWnd* win = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_UORDER));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_VORDER));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_SPIN_UORDER));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_SPIN_VORDER));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_UORDER));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_VORDER));
	win->EnableWindow(active);
}*/

void CSurfaceRebuildDlg::enable_SEParamRange(BOOL active){
	CWnd* win = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_US));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_UE));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_VS));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_VE));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_US));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_UE));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_VS));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_VE));
	win->EnableWindow(active);
}
/*
void CSurfaceRebuildDlg::enableMinimumEdgeLength(BOOL active){
	CWnd* win = static_cast<CWnd*>(GetDlgItem(IDC_STATIC_MIN_EDGE_LENGTH));
	win->EnableWindow(active);
	win = static_cast<CWnd*>(GetDlgItem(IDC_EDIT_MIN_EDGE_LEN));
	win->EnableWindow(active);
}

void CSurfaceRebuildDlg::enableEdgeRebuild(BOOL active){
	CWnd* win;
	win = static_cast<CWnd*>(GetDlgItem(IDC_CHECK_C1EDGE_JOIN));
	win->EnableWindow(active);
}*/

void CSurfaceRebuildDlg::get_surf_param(
	int& splineApprox,//=0: no spline approximation,
					//  =1: reconstruct as NURBS(may be rational)
					//  =2: reconstruct as non rational B-Spline.
	int& reparameterize,//Indicates how the parameter normalization be done:
		//=0: no surface parameter normalization.
		//=1: normalize to u_range=(0., 1.), and v_range=(0.,1.);
		//=2: normalize to make the average length of the 1st derivative along u and v 
		//    of the base surface is as equal to 1. as possible(that is chord length).
		//=3: Specify surface parameter range in range[].
	double& surfTolerance,
	//int ordr[2],//u-order and v-order
	double range[4]//[0],[1] u start and end, [2],[3] v start and end.
)const{
	splineApprox=0;
	if(m_nonRationalize)
		splineApprox=2;
	else if(m_parentCMD->sbrep() || m_parentCMD->rsbrep())
		splineApprox=1;

	reparameterize=m_reparameterize;
	surfTolerance=m_SurfTolerance;
	//ordr[0]=m_orderU;
	//ordr[1]=m_orderV;
	range[0]=m_USparam;
	range[1]=m_UEparam;
	range[2]=m_VSparam;
	range[3]=m_VEparam;
}

void CSurfaceRebuildDlg::get_face_param(
	int& splineApprox,//=0: no spline approximation,
					//  =1: reconstruct as NURBS(may be rational)
					//  =2: reconstruct as non rational B-Spline.
	int& reparameterize,//Indicates how the parameter normalization be done:
		//=0: no surface parameter normalization.
		//=1: normalize to u_range=(0., 1.), and v_range=(0.,1.);
		//=2: normalize to make the average length of the 1st derivative along u and v 
		//    of the base surface is as equal to 1. as possible(that is chord length).
		//=3: Specify surface parameter range in range[].
	double& surfTolerance,
	//int ordr[2],//u-order and v-order
	double range[4],//[0],[1] u start and end, [2],[3] v start and end.
	//bool& edgeRebuild,
	bool& C1EdgeJoin
	//bool& removeShortEdg,
	//double& minimumEdgeLength
)const{
	get_surf_param(splineApprox,reparameterize,surfTolerance,range);
	//edgeRebuild=m_edgeRebuild==TRUE;
	//if(edgeRebuild){
		C1EdgeJoin=m_C1EJoin==TRUE;
		//removeShortEdg=m_shortEdgeRemove==TRUE;
		//minimumEdgeLength=m_minimum_edge_length;
	//}
}

BEGIN_MESSAGE_MAP(CSurfaceRebuildDlg, CDialog)
	ON_BN_CLICKED(IDC_RADIO0_NO_REPARA, OnBnClickedRadio0NoRepara)
	ON_BN_CLICKED(IDC_RADIO1_01REPARA, OnBnClickedRadio101repara)
	ON_BN_CLICKED(IDC_RADIO2_CHORD_LENGTH, OnBnClickedRadio2ChordLength)
	ON_BN_CLICKED(IDC_RADIO3_SPECIFY_RANGE, OnBnClickedRadio3SpecifyRange)
	//ON_BN_CLICKED(IDC_CHECK_CHANGE_ORDER, OnBnClickedCheckChangeOrder)
	ON_BN_CLICKED(IDC_CHECK_NON_RATIONALIZE, OnBnClickedCheckNonRationalize)
	//ON_STN_CLICKED(IDC_STATIC_SURFACE_TYPE, &CSurfaceRebuildDlg::OnStnClickedStaticSurfaceType)
	//ON_BN_CLICKED(IDC_CHECK_C1EDGE_JOIN, &CSurfaceRebuildDlg::OnBnClickedCheckC1edgeJoin)
END_MESSAGE_MAP()


// CSurfaceRebuildDlg bZ[W nh

void CSurfaceRebuildDlg::OnBnClickedRadio0NoRepara(){
	m_reparameterize=0;
	enable_SEParamRange(FALSE);
}

void CSurfaceRebuildDlg::OnBnClickedRadio101repara(){
	m_reparameterize=1;
	enable_SEParamRange(FALSE);
}

void CSurfaceRebuildDlg::OnBnClickedRadio2ChordLength(){
	m_reparameterize=2;
	enable_SEParamRange(FALSE);
}

void CSurfaceRebuildDlg::OnBnClickedRadio3SpecifyRange(){
	m_reparameterize=3;
	enable_SEParamRange(TRUE);
	UpdateData(TRUE);
}

//void CSurfaceRebuildDlg::OnBnClickedCheckChangeOrder(){
//	UpdateData(TRUE);
//	enable_orderEdit(m_changeOrder);
//}

void CSurfaceRebuildDlg::OnBnClickedCheckNonRationalize(){
	UpdateData(TRUE);
	//enable_orderEdit(m_nonRationalize);
}

//void CSurfaceRebuildDlg::OnBnClickedShortEdgeRemove(){
//	UpdateData(TRUE);
//	enableMinimumEdgeLength(m_shortEdgeRemove);
//}

//void CSurfaceRebuildDlg::OnStnClickedStaticSurfaceType(){
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
//}

//void CSurfaceRebuildDlg::OnBnClickedCheckC1edgeJoin()
//{
	// TODO: ɃRg[ʒmnh[ R[hǉ܂B
//}
