/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfSweepToPointTool.h
 * @brief MGSurfSweepToPoint NX̃C^[tFCX
 */
#if !defined(AFX_SURFSWEEPTOPOINTTOOL_H__3DC64E5B_E593_4D7D_850F_BD4D9CF0FDD5__INCLUDED_)
#define AFX_SURFSWEEPTOPOINTTOOL_H__3DC64E5B_E593_4D7D_850F_BD4D9CF0FDD5__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

/// @class MGSurfSweepToPointTool SurfSweepToPointTool.h SurfCmd/SurfSweepToPointTool.h
///
/// Creates a surface by extrusion a curve to a point.
class MGSurfSweepToPointTool : public MGCommandStateOwner{
public:
	explicit MGSurfSweepToPointTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);

private:
	MGPickObject m_curve; ///< XC[vȐ
	MGPosition m_position; ///< ̈ʒu܂ŃXC[v

	friend class MGSurfSweepToPointSCurve;
	friend class MGSurfSweepToPointIPoint;
};

// ԃNX

/// @class MGSurfSweepToPointSCurve
///
/// MGSurfSweepToPointTool ŋȐI΂邽߂ command state
class MGSurfSweepToPointSCurve : public MGSelectState{
public:
	MGSurfSweepToPointSCurve(MGCommandStateOwner* owner);
	MGSurfSweepToPointTool* state_owner(){
		return static_cast<MGSurfSweepToPointTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

/// @class MGSurfSweepToPointIPoint
///
/// XC[v̏kޓ_ (?) indicate  state
class MGSurfSweepToPointIPoint : public MGLocateState{
public:
	MGSurfSweepToPointIPoint(MGCommandStateOwner* owner);
	MGSurfSweepToPointTool* state_owner(){
		return static_cast<MGSurfSweepToPointTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnLocated(const MGLocateInfo& info);
};

#endif // !defined(AFX_SURFSWEEPTOPOINTTOOL_H__3DC64E5B_E593_4D7D_850F_BD4D9CF0FDD5__INCLUDED_)
