/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfSweepRibbon.cpp
 * @brief MGSurfSweepRibbonTool NX̃Cve[V
 */
#include "stdafx.h"
#include "mg/Straight.h"
#include "mg/SBRep.h"
#include "mg/LBRep.h"
#include "mg/CSisects.h"
#include "fugenView.h"
#include "SurfCmd/SurfSweepRibbon.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// class MGSurfSweepRibbonTool

MGSurfSweepRibbonTool::MGSurfSweepRibbonTool(fugenDoc* pDoc)
: MGCommandStateOwner(pDoc, ID_SURFACE_EXTRUDE_RIBBON), m_curve(0){
}

MGCommandBase* MGSurfSweepRibbonTool::initial_clone(fugenDoc* pDoc)const{
	return new MGSurfSweepRibbonTool(pDoc);
}

bool MGSurfSweepRibbonTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();
	if(resetCurrentObjects(mgAll_Curve)
	   && current_objects().size() == 1){
		// ItZbgʒuXe[g
		m_curve = dynamic_cast<const MGCurve*>(current_objects().front().top_object());
		set_child_current_command(new MGSurfSweepRibbonIPoint(this));
	}else{
		// ȐIX^[g
		set_child_current_command(new MGSurfSweepRibbonSCurve(this));
	}
	return false;
}

bool MGSurfSweepRibbonTool::calculate(){
	if(m_perims.empty()){
		// s
		return false;
	}else if(m_perims.size() == 1){
		UniqueCurve tmp2[2] = {
			std::unique_ptr<MGCurve>(new MGStraight(m_curve->start_point(), m_perims[0]->start_point())),
			std::unique_ptr<MGCurve>(new MGStraight(m_curve->end_point(), m_perims[0]->end_point()))
		};
		const MGCurve* tmp[4] = { tmp2[0].get(), m_curve, tmp2[1].get(), m_perims[0].get()};

		// m_curve, s2, c, s1 ͂ދȖʂ𐶐...
		std::unique_ptr<MGLBRep> perim2[4];
		int ret = construct_perimeters(tmp, perim2);
		MGSBRep* srf = new MGSBRep; srf->buildGeneralizedRuledSurface(perim2,false);
		add_object_to_current_group(srf);
	}else{
		// 
		return false;
	}

	return true;
}

// class MGSurfSweepRibbonSCurve

MGSurfSweepRibbonSCurve::MGSurfSweepRibbonSCurve(MGSurfSweepRibbonTool* owner)
: MGSelectState(owner, MGSelectState::SINGLE_SELECT, mgAll_Curve){
}

bool MGSurfSweepRibbonSCurve::initiate_tool(){
	MGSelectState::initiate_tool();
	clear_pick_object();
	prompt_message();
	return false;
}

bool MGSurfSweepRibbonSCurve::OnSelected(
	fugenView* pView,
	MGPickObjects& objs,
	MGPickObjects& unobjs
){
	ASSERT(objs.size() == 1);
	const MGObject* obj = objs.front().top_object();
	ASSERT(obj);
	const MGCurve* curve = dynamic_cast<const MGCurve*>(obj);
	ASSERT(curve);
	
	// ȐL
	MGSurfSweepRibbonTool* owner = state_owner();
	owner->m_curve = curve;

	//  state 
	set_sibling_next_command(new MGSurfSweepRibbonIPoint(owner));
	return false;
}

void MGSurfSweepRibbonSCurve::prompt_message()const{
	SetStatusMessage(IDS_PROMPT_CURVE);
}

// class MGSurfSweepRibbonIPoint

MGSurfSweepRibbonIPoint::MGSurfSweepRibbonIPoint(MGSurfSweepRibbonTool* owner)
: MGLocateState(owner, 
LOCK_SNAP_ATTRIB,//Prohibit to update snap attrib
NO_RUBBER, POINT_IPDRAW){
	// ȐɃXibv
	turn_on_near();
	turn_on_end();
}

bool MGSurfSweepRibbonIPoint::OnLocated(const MGLocateInfo& info){
	MGSurfSweepRibbonTool* owner = state_owner();
	ASSERT(owner->m_curve);

	const MGCurve& curve = *owner->m_curve;

	// 1. }EXJ[\ʒuɂ gluLookAt r[
	MGStraight ray;
	info.window()->unproject_to_sl(info.point_screen(), ray);

	// 2. ԋ߂_
	MGPosition param = curve.closest(ray);
	MGPosition pos = curve.eval(param[0]);
	MGPosition ref = ray.eval(param[1]);

	// Ȗʂ𐶐...
	MGVector v1 = ref - pos;
	MGVector T, N, B;
	double curva, tors;
	curve.Frenet_frame(param[0], T, N, B, curva, tors);
	
	double len = v1 % N; // ItZbglɓĂ

	owner->m_perims = curve.offset(len, B);

	if(!owner->calculate()){
		return OnCommandEnd(3);
	}
	return OnCommandEnd(1);
}

void MGSurfSweepRibbonIPoint::prompt_message() const{
	SetStatusMessage(IDS_PROMPT_LENGTH);
}


// }EXJ[\^[Qbg̋Ȑɋ߂ÂƂɁA
// closest ȋȐ̓_琂ꎞ\B
//
// ̓_ɂڃxNg@Ƃ镽ʂƁA
// }EXr[Ƃ̌_vZA܂ł̐ꎞ\B
void MGSurfSweepRibbonIPoint::do_make_temporary_display(mgSysGL& sgl,fugenView* pView){	
	MGSurfSweepRibbonTool* owner = state_owner();
	ASSERT(owner->m_curve);

	const MGCurve& curve = *owner->m_curve;

	// 1. }EXJ[\ʒuɂ gluLookAt r[
	MGStraight ray;
	CPoint point=pView->mousemove_old_point();
	pView->unproject_to_sl(point, ray);

	// 2. ԋ߂_
	MGPosition param = curve.closest(ray);
	MGPosition pos = curve.eval(param[0]);
	MGPosition ref = ray.eval(param[1]);
	sgl.setStaticAttribColor(.5f,1.f,.5f);
	sgl.drawStraight(pos, ref);
}
