/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfSweepExtrudeTool.h
 * @brief MGSurfSweepExtrudeTool NX̃C^[tFCX
 */
#if !defined(AFX_SWEEPSRFTOOL_H__B20BB1B5_8CB1_42EF_9DA6_B2F0209F53BE__INCLUDED_)
#define AFX_SWEEPSRFTOOL_H__B20BB1B5_8CB1_42EF_9DA6_B2F0209F53BE__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/CommandStateOwner.h"
#include "Common/SelectState.h"
#include "Common/LocateState.h"

/// @class MGSurfSweepExtrudeTool SurfSweepExtrudeTool.h SurfCmd/SurfSweepExtrudeTool.h
///
/// Creates a surface to extrude a curve straightforwardly.
class MGSurfSweepExtrudeTool : public MGCommandStateOwner{
public:
	explicit MGSurfSweepExtrudeTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);

private:
	bool calculate();
	bool check_current();

	bool m_bBoth; ///< XC[v
	MGPosition m_org; ///< XC[vn_
	MGPosition m_dest; ///< XC[vI_
	std::vector<const MGObject*> m_draw; ///< ꎞ`p

	friend class MGSurfSweepStraightSCurve;
	friend class MGSurfSweepStraightIPoint;
};

/// @class MGSurfSweepStraightSCurve
///
/// XC[vȐI state
class MGSurfSweepStraightSCurve : public MGSelectState{
public:
	MGSurfSweepStraightSCurve(MGSurfSweepExtrudeTool* owner);
	MGSurfSweepExtrudeTool* state_owner(){
		return static_cast<MGSurfSweepExtrudeTool*>(get_owner_command());
	}

	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);
};

/// @class MGSurfSweepStraightIPoint
///
/// XC[v}EXŎw肷 state
class MGSurfSweepStraightIPoint : public MGLocateState{
public:
	MGSurfSweepStraightIPoint(MGSurfSweepExtrudeTool* owner);
	MGSurfSweepExtrudeTool* state_owner(){
		return static_cast<MGSurfSweepExtrudeTool*>(get_owner_command());
	}
	const MGSurfSweepExtrudeTool* state_owner()const {
		return static_cast<const MGSurfSweepExtrudeTool*>(get_owner_command());
	}

	virtual bool OnKeyDown(fugenView* window, UINT nChar,UINT nRepCnt, UINT nFlags);
	virtual bool OnLocated(const MGLocateInfo& info);
	virtual void do_make_temporary_display(mgSysGL& sgl,fugenView* pView);
	void prompt_message()const;

private:
	bool adjust(fugenView* pView, CPoint point);
};

#endif // !defined(AFX_SWEEPSRFTOOL_H__B20BB1B5_8CB1_42EF_9DA6_B2F0209F53BE__INCLUDED_)
