/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfSweepAlongCurveTool.h
 * @brief MGSurfSweepAlongCurveTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFSWEEPALONGCURVETOOL_H__4165DE8D_739C_4B65_B939_04F0EBB95B82__INCLUDED_)
#define AFX_SURFSWEEPALONGCURVETOOL_H__4165DE8D_739C_4B65_B939_04F0EBB95B82__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfSweepAlongCurveTool SurfSweepAlongCurveTool.h SurfCmd/SurfSweepAlongCurveTool.h
///
/// Creates a surface by extrusion a curve along a path curve.
class MGSurfSweepAlongCurveTool : public MGSelectState{
public:
	explicit MGSurfSweepAlongCurveTool(fugenDoc* pDoc = 0);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnCommandCanceled(UINT nIDS);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
		//=1: display "xxxx" normally end.
		//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	MGPickObject m_shape_curve; ///< XC[vȐ
	MGPickObject m_path_curve; ///< XC[v̋OՂ\Ȑ
};

#endif // !defined(AFX_SURFSWEEPALONGCURVETOOL_H__4165DE8D_739C_4B65_B939_04F0EBB95B82__INCLUDED_)
