/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/

/**
 * @file SurfSplitIso.cpp
 * @brief SurfSplitIso.h ̎
 */
#include "stdafx.h"
#include "fugenView.h"
#include "Calc/mgcalc.h"
#include "SurfCmd/SplitLocateIsocurves.h"
#include "SurfCmd/SurfSplitIso.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

// MGSurfSplitIsoTool

MGSurfSplitIsoTool::MGSurfSplitIsoTool(fugenDoc* pDoc)
: MGCommandStateOwner(pDoc, ID_SURFACE_SPLIT_ISOCURVE),m_direction(0){
}

MGCommandBase* MGSurfSplitIsoTool::initial_clone(fugenDoc* pDoc)const{
	return new MGSurfSplitIsoTool(pDoc);
}

bool MGSurfSplitIsoTool::initiate_tool(){
	MGCommandStateOwner::initiate_tool();

	// ɋȖʂЂƂIĂ悤ȏꍇ
	// XLbv\
	MGPickObjects curobj(current_objects());
	curobj.remove(mgAll_Plane);

	if(resetCurrentObjects(mgAll_FSurface) && curobj.size() == 1){
		// _͂X^[g
		set_child_current_command(new MGSplitLocateIsocurves(this,curobj.front()));
	}else{
		// ]vȑIfNAăX^[g
		clear_pick_object();
		set_child_current_command(new MGSurfSplitIsoSSurf(this));
	}
	return false;
}

// MGSurfSplitIsoSSurf

MGSurfSplitIsoSSurf::MGSurfSplitIsoSSurf(MGSurfSplitIsoTool* owner)
: MGSelectState(owner,SINGLE_SELECT,mgAll_FSurface){ // plane ̓AEg
}

bool MGSurfSplitIsoSSurf::initiate_tool(){
	MGSelectState::initiate_tool();

	// ŏ̃bZ[W
	SetStatusMessage(IDS_PROMPT_SURFACE);
	return false;
}

bool MGSurfSplitIsoSSurf::OnSelected(
	fugenView* window,//The fugenView pointer where point input event took place.
	MGPickObjects&	objs,	//selected objects at this selection operation.
	MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
){
	ASSERT(objs.size() == 1);
	ASSERT(objs.front().top_object()->fsurface());

	objs.remove(mgAll_Plane);
	// ʃ`FbN
	if(objs.empty()){
		// Ȃ̂悤ɕA
		SetStatusMessage(IDS_PROMPT_SURFACE);
		return false;
	}

	// OK. stateɓ
	set_sibling_next_command(new MGSplitLocateIsocurves(state_owner(),objs.front()));
	return false;
}
