/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfSmooth.h
 * @brief MGSurfSmoothTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFSMOOTH_H__66BF6381_4813_400D_AB29_C3D4FD57C94C__INCLUDED_)
#define AFX_SURFSMOOTH_H__66BF6381_4813_400D_AB29_C3D4FD57C94C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfSmoothTool SurfSmooth.h SurfCmd/SurfSmooth.h
///
/// Smooths a surface.
class MGSurfSmoothTool : public MGSelectState{
public:
	explicit MGSurfSmoothTool(fugenDoc* pDocs);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
				//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	bool input_param();

	MGPickObject m_surf; ///< X[WO MGSBRep
	double m_dSmooth; ///< X[WOW
};

#endif // !defined(AFX_SURFSMOOTH_H__66BF6381_4813_400D_AB29_C3D4FD57C94C__INCLUDED_)
