/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfShrink.h
 * @brief MGSurfShrinkTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFSHRINK_H__6DB9EDC3_1E57_44F7_8B02_B622D127896C__INCLUDED_)
#define AFX_SURFSHRINK_H__6DB9EDC3_1E57_44F7_8B02_B622D127896C__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfShrinkTool SurfShrink.h SurfCmd/SurfShrink.h
///
/// Shrinks the underlying untrimmed surface near to trimming boundaries.
class MGSurfShrinkTool : public MGSelectState{
public:
	explicit MGSurfShrinkTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool OnSelected(
		fugenView* pView,
		MGPickObjects& selobj,
		MGPickObjects& remobj);

private:
	bool calculate();
	void prompt_message() const;

	UINT m_nIDS; ///< error message
};

#endif // !defined(AFX_SURFSHRINK_H__6DB9EDC3_1E57_44F7_8B02_B622D127896C__INCLUDED_)
