/********************************************************************/
/* Copyright (c) 2019 System fugen G.K. and Yuzi Mizuno          */
/* All rights reserved.                                             */
/********************************************************************/
/********************************************************************/
/**
 * @file SurfOffsetTool.h
 * @brief MGSurfOffsetTool NX̃C^[tFCX
 */
#if !defined(AFX_SURFOFFSETTOOL_H__9F019BC1_4FAF_4355_8412_9742D80775E6__INCLUDED_)
#define AFX_SURFOFFSETTOOL_H__9F019BC1_4FAF_4355_8412_9742D80775E6__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Common/SelectState.h"

/// @class MGSurfOffsetTool SurfOffsetTool.h SurfCmd/SurfOffsetTool.h
///
/// Offsets a surface/face.
class MGSurfOffsetTool : public MGSelectState{
public:
	explicit MGSurfOffsetTool(fugenDoc* pDoc);

	virtual MGCommandBase* initial_clone(fugenDoc* pDoc)const;
	virtual bool initiate_tool();
	virtual bool terminate_tool(bool cancel = false);
	virtual bool OnCommandEnd(
		UINT nIDS,	//=0: erase the current message, and display no messages.
				//=1: display "xxxx" normally end.
		//otherwise: nIDS is a string id, and load the message from string table to display.
		bool erase_temporary_display=true);
	virtual bool OnSelected(
		fugenView* window,//The fugenView pointer where point input event took place.
		MGPickObjects&	objs,	//selected objects at this selection operation.
		MGPickObjects&	unselected_objects	//unselected objects at this selection operation.
		//unselected_objects.size()>=1 only when the already selected objects are selected
		//when add mode is set(or when operation is done with a crtl key pressed).
		);

private:
	bool input_param();

	double m_dOffset; ///< ItZbg
	MGPickObjects m_srf; ///< ItZbg邷ׂĂ MGFSurface
};

#endif // !defined(AFX_SURFOFFSETTOOL_H__9F019BC1_4FAF_4355_8412_9742D80775E6__INCLUDED_)
